/* This file is generated by venus-protocol.  See vn_protocol_driver.h. */

/*
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: MIT
 */

#ifndef VN_PROTOCOL_DRIVER_INSTANCE_H
#define VN_PROTOCOL_DRIVER_INSTANCE_H

#include "vn_ring.h"
#include "vn_protocol_driver_structs.h"

/*
 * These structs/unions/commands are not included
 *
 *   vkGetInstanceProcAddr
 */

/* struct VkApplicationInfo chain */

static inline size_t
vn_sizeof_VkApplicationInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkApplicationInfo_self(const VkApplicationInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    if (val->pApplicationName) {
        const size_t string_size = strlen(val->pApplicationName) + 1;
        size += vn_sizeof_array_size(string_size);
        size += vn_sizeof_char_array(val->pApplicationName, string_size);
    } else {
        size += vn_sizeof_array_size(0);
    }
    size += vn_sizeof_uint32_t(&val->applicationVersion);
    if (val->pEngineName) {
        const size_t string_size = strlen(val->pEngineName) + 1;
        size += vn_sizeof_array_size(string_size);
        size += vn_sizeof_char_array(val->pEngineName, string_size);
    } else {
        size += vn_sizeof_array_size(0);
    }
    size += vn_sizeof_uint32_t(&val->engineVersion);
    size += vn_sizeof_uint32_t(&val->apiVersion);
    return size;
}

static inline size_t
vn_sizeof_VkApplicationInfo(const VkApplicationInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkApplicationInfo_pnext(val->pNext);
    size += vn_sizeof_VkApplicationInfo_self(val);

    return size;
}

static inline void
vn_encode_VkApplicationInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkApplicationInfo_self(struct vn_cs_encoder *enc, const VkApplicationInfo *val)
{
    /* skip val->{sType,pNext} */
    if (val->pApplicationName) {
        const size_t string_size = strlen(val->pApplicationName) + 1;
        vn_encode_array_size(enc, string_size);
        vn_encode_char_array(enc, val->pApplicationName, string_size);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_uint32_t(enc, &val->applicationVersion);
    if (val->pEngineName) {
        const size_t string_size = strlen(val->pEngineName) + 1;
        vn_encode_array_size(enc, string_size);
        vn_encode_char_array(enc, val->pEngineName, string_size);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_uint32_t(enc, &val->engineVersion);
    vn_encode_uint32_t(enc, &val->apiVersion);
}

static inline void
vn_encode_VkApplicationInfo(struct vn_cs_encoder *enc, const VkApplicationInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_APPLICATION_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_APPLICATION_INFO });
    vn_encode_VkApplicationInfo_pnext(enc, val->pNext);
    vn_encode_VkApplicationInfo_self(enc, val);
}

/* struct VkInstanceCreateInfo chain */

static inline size_t
vn_sizeof_VkInstanceCreateInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkInstanceCreateInfo_self(const VkInstanceCreateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->flags);
    size += vn_sizeof_simple_pointer(val->pApplicationInfo);
    if (val->pApplicationInfo)
        size += vn_sizeof_VkApplicationInfo(val->pApplicationInfo);
    size += vn_sizeof_uint32_t(&val->enabledLayerCount);
    if (val->ppEnabledLayerNames) {
        size += vn_sizeof_array_size(val->enabledLayerCount);
        for (uint32_t i = 0; i < val->enabledLayerCount; i++) {
            const size_t string_size = strlen(val->ppEnabledLayerNames[i]) + 1;
            size += vn_sizeof_array_size(string_size);
            size += vn_sizeof_char_array(val->ppEnabledLayerNames[i], string_size);
        }
    } else {
        size += vn_sizeof_array_size(0);
    }
    size += vn_sizeof_uint32_t(&val->enabledExtensionCount);
    if (val->ppEnabledExtensionNames) {
        size += vn_sizeof_array_size(val->enabledExtensionCount);
        for (uint32_t i = 0; i < val->enabledExtensionCount; i++) {
            const size_t string_size = strlen(val->ppEnabledExtensionNames[i]) + 1;
            size += vn_sizeof_array_size(string_size);
            size += vn_sizeof_char_array(val->ppEnabledExtensionNames[i], string_size);
        }
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkInstanceCreateInfo(const VkInstanceCreateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkInstanceCreateInfo_pnext(val->pNext);
    size += vn_sizeof_VkInstanceCreateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkInstanceCreateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkInstanceCreateInfo_self(struct vn_cs_encoder *enc, const VkInstanceCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->flags);
    if (vn_encode_simple_pointer(enc, val->pApplicationInfo))
        vn_encode_VkApplicationInfo(enc, val->pApplicationInfo);
    vn_encode_uint32_t(enc, &val->enabledLayerCount);
    if (val->ppEnabledLayerNames) {
        vn_encode_array_size(enc, val->enabledLayerCount);
        for (uint32_t i = 0; i < val->enabledLayerCount; i++) {
            const size_t string_size = strlen(val->ppEnabledLayerNames[i]) + 1;
            vn_encode_array_size(enc, string_size);
            vn_encode_char_array(enc, val->ppEnabledLayerNames[i], string_size);
        }
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_uint32_t(enc, &val->enabledExtensionCount);
    if (val->ppEnabledExtensionNames) {
        vn_encode_array_size(enc, val->enabledExtensionCount);
        for (uint32_t i = 0; i < val->enabledExtensionCount; i++) {
            const size_t string_size = strlen(val->ppEnabledExtensionNames[i]) + 1;
            vn_encode_array_size(enc, string_size);
            vn_encode_char_array(enc, val->ppEnabledExtensionNames[i], string_size);
        }
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkInstanceCreateInfo(struct vn_cs_encoder *enc, const VkInstanceCreateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_INSTANCE_CREATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_INSTANCE_CREATE_INFO });
    vn_encode_VkInstanceCreateInfo_pnext(enc, val->pNext);
    vn_encode_VkInstanceCreateInfo_self(enc, val);
}

static inline size_t vn_sizeof_vkCreateInstance(const VkInstanceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkInstance* pInstance)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreateInstance_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_simple_pointer(pCreateInfo);
    if (pCreateInfo)
        cmd_size += vn_sizeof_VkInstanceCreateInfo(pCreateInfo);
    cmd_size += vn_sizeof_simple_pointer(pAllocator);
    if (pAllocator)
        assert(false);
    cmd_size += vn_sizeof_simple_pointer(pInstance);
    if (pInstance)
        cmd_size += vn_sizeof_VkInstance(pInstance);

    return cmd_size;
}

static inline void vn_encode_vkCreateInstance(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, const VkInstanceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkInstance* pInstance)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreateInstance_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    if (vn_encode_simple_pointer(enc, pCreateInfo))
        vn_encode_VkInstanceCreateInfo(enc, pCreateInfo);
    if (vn_encode_simple_pointer(enc, pAllocator))
        assert(false);
    if (vn_encode_simple_pointer(enc, pInstance))
        vn_encode_VkInstance(enc, pInstance);
}

static inline size_t vn_sizeof_vkCreateInstance_reply(const VkInstanceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkInstance* pInstance)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreateInstance_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip pCreateInfo */
    /* skip pAllocator */
    cmd_size += vn_sizeof_simple_pointer(pInstance);
    if (pInstance)
        cmd_size += vn_sizeof_VkInstance(pInstance);

    return cmd_size;
}

static inline VkResult vn_decode_vkCreateInstance_reply(struct vn_cs_decoder *dec, const VkInstanceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkInstance* pInstance)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCreateInstance_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip pCreateInfo */
    /* skip pAllocator */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkInstance(dec, pInstance);
    } else {
        pInstance = NULL;
    }

    return ret;
}

static inline size_t vn_sizeof_vkDestroyInstance(VkInstance instance, const VkAllocationCallbacks* pAllocator)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkDestroyInstance_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkInstance(&instance);
    cmd_size += vn_sizeof_simple_pointer(pAllocator);
    if (pAllocator)
        assert(false);

    return cmd_size;
}

static inline void vn_encode_vkDestroyInstance(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkInstance instance, const VkAllocationCallbacks* pAllocator)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkDestroyInstance_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkInstance(enc, &instance);
    if (vn_encode_simple_pointer(enc, pAllocator))
        assert(false);
}

static inline size_t vn_sizeof_vkDestroyInstance_reply(VkInstance instance, const VkAllocationCallbacks* pAllocator)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkDestroyInstance_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip instance */
    /* skip pAllocator */

    return cmd_size;
}

static inline void vn_decode_vkDestroyInstance_reply(struct vn_cs_decoder *dec, VkInstance instance, const VkAllocationCallbacks* pAllocator)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkDestroyInstance_EXT);

    /* skip instance */
    /* skip pAllocator */
}

static inline size_t vn_sizeof_vkEnumerateInstanceVersion(uint32_t* pApiVersion)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkEnumerateInstanceVersion_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_simple_pointer(pApiVersion); /* out */

    return cmd_size;
}

static inline void vn_encode_vkEnumerateInstanceVersion(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, uint32_t* pApiVersion)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkEnumerateInstanceVersion_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_simple_pointer(enc, pApiVersion); /* out */
}

static inline size_t vn_sizeof_vkEnumerateInstanceVersion_reply(uint32_t* pApiVersion)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkEnumerateInstanceVersion_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    cmd_size += vn_sizeof_simple_pointer(pApiVersion);
    if (pApiVersion)
        cmd_size += vn_sizeof_uint32_t(pApiVersion);

    return cmd_size;
}

static inline VkResult vn_decode_vkEnumerateInstanceVersion_reply(struct vn_cs_decoder *dec, uint32_t* pApiVersion)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkEnumerateInstanceVersion_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_uint32_t(dec, pApiVersion);
    } else {
        pApiVersion = NULL;
    }

    return ret;
}

static inline size_t vn_sizeof_vkEnumerateInstanceLayerProperties(uint32_t* pPropertyCount, VkLayerProperties* pProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkEnumerateInstanceLayerProperties_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_simple_pointer(pPropertyCount);
    if (pPropertyCount)
        cmd_size += vn_sizeof_uint32_t(pPropertyCount);
    if (pProperties) {
        cmd_size += vn_sizeof_array_size((pPropertyCount ? *pPropertyCount : 0));
        for (uint32_t i = 0; i < (pPropertyCount ? *pPropertyCount : 0); i++)
            cmd_size += vn_sizeof_VkLayerProperties_partial(&pProperties[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkEnumerateInstanceLayerProperties(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, uint32_t* pPropertyCount, VkLayerProperties* pProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkEnumerateInstanceLayerProperties_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    if (vn_encode_simple_pointer(enc, pPropertyCount))
        vn_encode_uint32_t(enc, pPropertyCount);
    if (pProperties) {
        vn_encode_array_size(enc, (pPropertyCount ? *pPropertyCount : 0));
        for (uint32_t i = 0; i < (pPropertyCount ? *pPropertyCount : 0); i++)
            vn_encode_VkLayerProperties_partial(enc, &pProperties[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkEnumerateInstanceLayerProperties_reply(uint32_t* pPropertyCount, VkLayerProperties* pProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkEnumerateInstanceLayerProperties_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    cmd_size += vn_sizeof_simple_pointer(pPropertyCount);
    if (pPropertyCount)
        cmd_size += vn_sizeof_uint32_t(pPropertyCount);
    if (pProperties) {
        cmd_size += vn_sizeof_array_size((pPropertyCount ? *pPropertyCount : 0));
        for (uint32_t i = 0; i < (pPropertyCount ? *pPropertyCount : 0); i++)
            cmd_size += vn_sizeof_VkLayerProperties(&pProperties[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline VkResult vn_decode_vkEnumerateInstanceLayerProperties_reply(struct vn_cs_decoder *dec, uint32_t* pPropertyCount, VkLayerProperties* pProperties)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkEnumerateInstanceLayerProperties_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_uint32_t(dec, pPropertyCount);
    } else {
        pPropertyCount = NULL;
    }
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, (pPropertyCount ? *pPropertyCount : 0));
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkLayerProperties(dec, &pProperties[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        pProperties = NULL;
    }

    return ret;
}

static inline size_t vn_sizeof_vkEnumerateInstanceExtensionProperties(const char* pLayerName, uint32_t* pPropertyCount, VkExtensionProperties* pProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkEnumerateInstanceExtensionProperties_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    if (pLayerName) {
        const size_t string_size = strlen(pLayerName) + 1;
        cmd_size += vn_sizeof_array_size(string_size);
        cmd_size += vn_sizeof_char_array(pLayerName, string_size);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }
    cmd_size += vn_sizeof_simple_pointer(pPropertyCount);
    if (pPropertyCount)
        cmd_size += vn_sizeof_uint32_t(pPropertyCount);
    if (pProperties) {
        cmd_size += vn_sizeof_array_size((pPropertyCount ? *pPropertyCount : 0));
        for (uint32_t i = 0; i < (pPropertyCount ? *pPropertyCount : 0); i++)
            cmd_size += vn_sizeof_VkExtensionProperties_partial(&pProperties[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkEnumerateInstanceExtensionProperties(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, const char* pLayerName, uint32_t* pPropertyCount, VkExtensionProperties* pProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkEnumerateInstanceExtensionProperties_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    if (pLayerName) {
        const size_t string_size = strlen(pLayerName) + 1;
        vn_encode_array_size(enc, string_size);
        vn_encode_char_array(enc, pLayerName, string_size);
    } else {
        vn_encode_array_size(enc, 0);
    }
    if (vn_encode_simple_pointer(enc, pPropertyCount))
        vn_encode_uint32_t(enc, pPropertyCount);
    if (pProperties) {
        vn_encode_array_size(enc, (pPropertyCount ? *pPropertyCount : 0));
        for (uint32_t i = 0; i < (pPropertyCount ? *pPropertyCount : 0); i++)
            vn_encode_VkExtensionProperties_partial(enc, &pProperties[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkEnumerateInstanceExtensionProperties_reply(const char* pLayerName, uint32_t* pPropertyCount, VkExtensionProperties* pProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkEnumerateInstanceExtensionProperties_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip pLayerName */
    cmd_size += vn_sizeof_simple_pointer(pPropertyCount);
    if (pPropertyCount)
        cmd_size += vn_sizeof_uint32_t(pPropertyCount);
    if (pProperties) {
        cmd_size += vn_sizeof_array_size((pPropertyCount ? *pPropertyCount : 0));
        for (uint32_t i = 0; i < (pPropertyCount ? *pPropertyCount : 0); i++)
            cmd_size += vn_sizeof_VkExtensionProperties(&pProperties[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline VkResult vn_decode_vkEnumerateInstanceExtensionProperties_reply(struct vn_cs_decoder *dec, const char* pLayerName, uint32_t* pPropertyCount, VkExtensionProperties* pProperties)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkEnumerateInstanceExtensionProperties_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip pLayerName */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_uint32_t(dec, pPropertyCount);
    } else {
        pPropertyCount = NULL;
    }
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, (pPropertyCount ? *pPropertyCount : 0));
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkExtensionProperties(dec, &pProperties[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        pProperties = NULL;
    }

    return ret;
}

static inline void vn_submit_vkCreateInstance(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, const VkInstanceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkInstance* pInstance, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCreateInstance(pCreateInfo, pAllocator, pInstance);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCreateInstance_reply(pCreateInfo, pAllocator, pInstance) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCreateInstance(enc, cmd_flags, pCreateInfo, pAllocator, pInstance);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkDestroyInstance(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkInstance instance, const VkAllocationCallbacks* pAllocator, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkDestroyInstance(instance, pAllocator);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkDestroyInstance_reply(instance, pAllocator) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkDestroyInstance(enc, cmd_flags, instance, pAllocator);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkEnumerateInstanceVersion(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, uint32_t* pApiVersion, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkEnumerateInstanceVersion(pApiVersion);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkEnumerateInstanceVersion_reply(pApiVersion) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkEnumerateInstanceVersion(enc, cmd_flags, pApiVersion);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkEnumerateInstanceLayerProperties(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, uint32_t* pPropertyCount, VkLayerProperties* pProperties, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkEnumerateInstanceLayerProperties(pPropertyCount, pProperties);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkEnumerateInstanceLayerProperties_reply(pPropertyCount, pProperties) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkEnumerateInstanceLayerProperties(enc, cmd_flags, pPropertyCount, pProperties);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkEnumerateInstanceExtensionProperties(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, const char* pLayerName, uint32_t* pPropertyCount, VkExtensionProperties* pProperties, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkEnumerateInstanceExtensionProperties(pLayerName, pPropertyCount, pProperties);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkEnumerateInstanceExtensionProperties_reply(pLayerName, pPropertyCount, pProperties) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkEnumerateInstanceExtensionProperties(enc, cmd_flags, pLayerName, pPropertyCount, pProperties);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline VkResult vn_call_vkCreateInstance(struct vn_ring *vn_ring, const VkInstanceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkInstance* pInstance)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCreateInstance(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, pCreateInfo, pAllocator, pInstance, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkCreateInstance_reply(dec, pCreateInfo, pAllocator, pInstance);
        vn_ring_free_command_reply(vn_ring, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkCreateInstance(struct vn_ring *vn_ring, const VkInstanceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkInstance* pInstance)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCreateInstance(vn_ring, 0, pCreateInfo, pAllocator, pInstance, &submit);
}

static inline void vn_async_vkDestroyInstance(struct vn_ring *vn_ring, VkInstance instance, const VkAllocationCallbacks* pAllocator)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkDestroyInstance(vn_ring, 0, instance, pAllocator, &submit);
}

static inline VkResult vn_call_vkEnumerateInstanceVersion(struct vn_ring *vn_ring, uint32_t* pApiVersion)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkEnumerateInstanceVersion(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, pApiVersion, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkEnumerateInstanceVersion_reply(dec, pApiVersion);
        vn_ring_free_command_reply(vn_ring, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkEnumerateInstanceVersion(struct vn_ring *vn_ring, uint32_t* pApiVersion)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkEnumerateInstanceVersion(vn_ring, 0, pApiVersion, &submit);
}

static inline VkResult vn_call_vkEnumerateInstanceLayerProperties(struct vn_ring *vn_ring, uint32_t* pPropertyCount, VkLayerProperties* pProperties)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkEnumerateInstanceLayerProperties(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, pPropertyCount, pProperties, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkEnumerateInstanceLayerProperties_reply(dec, pPropertyCount, pProperties);
        vn_ring_free_command_reply(vn_ring, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkEnumerateInstanceLayerProperties(struct vn_ring *vn_ring, uint32_t* pPropertyCount, VkLayerProperties* pProperties)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkEnumerateInstanceLayerProperties(vn_ring, 0, pPropertyCount, pProperties, &submit);
}

static inline VkResult vn_call_vkEnumerateInstanceExtensionProperties(struct vn_ring *vn_ring, const char* pLayerName, uint32_t* pPropertyCount, VkExtensionProperties* pProperties)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkEnumerateInstanceExtensionProperties(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, pLayerName, pPropertyCount, pProperties, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkEnumerateInstanceExtensionProperties_reply(dec, pLayerName, pPropertyCount, pProperties);
        vn_ring_free_command_reply(vn_ring, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkEnumerateInstanceExtensionProperties(struct vn_ring *vn_ring, const char* pLayerName, uint32_t* pPropertyCount, VkExtensionProperties* pProperties)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkEnumerateInstanceExtensionProperties(vn_ring, 0, pLayerName, pPropertyCount, pProperties, &submit);
}

#endif /* VN_PROTOCOL_DRIVER_INSTANCE_H */
