package com.kreative.bitsnpicas.importer;

import java.io.*;
import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontGlyph;
import com.kreative.bitsnpicas.BitmapFontImporter;
import com.kreative.bitsnpicas.Font;

public class S10BitmapFontImporter implements BitmapFontImporter {
	public BitmapFont[] importFont(byte[] data) throws IOException {
		return importFont(new ByteArrayInputStream(data));
	}

	public BitmapFont[] importFont(File file) throws IOException {
		return importFont(new FileInputStream(file));
	}

	public BitmapFont[] importFont(InputStream is) throws IOException {
		BitmapFont[] fonts = new BitmapFont[] {
			new BitmapFont(7,1,7,1,5,7,0),
			new BitmapFont(7,1,7,1,5,7,0),
			new BitmapFont(7,1,7,1,5,7,0),
			new BitmapFont(7,1,7,1,5,7,0),
			new BitmapFont(7,1,7,1,5,7,0),
			new BitmapFont(7,1,7,1,5,7,0)
		};
		for (BitmapFont font : fonts) font.setName(Font.NAME_COPYRIGHT, "From SabineOS 1.0 (*shudder*), (c) 2000 Kreative Software");
		fonts[0].setName(Font.NAME_FAMILY, "Sabine Doscbthm");
		fonts[0].setName(Font.NAME_STYLE, "Normal");
		fonts[1].setName(Font.NAME_FAMILY, "Sabine Doscbthm Serif");
		fonts[1].setName(Font.NAME_STYLE, "Normal");
		fonts[2].setName(Font.NAME_FAMILY, "Sabine Doscbthm");
		fonts[2].setName(Font.NAME_STYLE, "Black");
		fonts[3].setName(Font.NAME_FAMILY, "Sabine Doscbthm");
		fonts[3].setName(Font.NAME_STYLE, "Oblique");
		fonts[4].setName(Font.NAME_FAMILY, "Sabine Doscbthm Small");
		fonts[4].setName(Font.NAME_STYLE, "Normal");
		fonts[5].setName(Font.NAME_FAMILY, "Sabine Doscbthm Script");
		fonts[5].setName(Font.NAME_STYLE, "Normal");
		for (int i = 0; i < 1024 && is.available() > 0; i++) {
			byte[] stuff = new byte[8];
			is.read(stuff);
			stuff = unpack(stuff);
			byte[][] glyph = new byte[8][8];
			for (int idx = 0, y = 0; y < 8; y++) {
				for (int x = 0; x < 8; x++, idx++) {
					glyph[y][x] = ((stuff[idx] != 0) ? (byte)0xFF : (byte)0x00);
				}
			}
			BitmapFontGlyph g = new BitmapFontGlyph(glyph, 0, 8, 7);
			for (BitmapFont font : fonts) font.putCharacter(0xF000+i, g);
			int[] chs = getMap(MAP_SANS_LO, MAP_SANS_HI, i);
			if (chs != null) {
				for (int ch : chs) {
					fonts[0].putCharacter(ch, g);
				}
			}
			chs = getMap(MAP_SERIF_LO, MAP_SERIF_HI, i);
			if (chs != null) {
				for (int ch : chs) {
					fonts[1].putCharacter(ch, g);
				}
			}
			chs = getMap(MAP_SOLID_LO, MAP_SOLID_HI, i);
			if (chs != null) {
				for (int ch : chs) {
					fonts[2].putCharacter(ch, g);
				}
			}
			chs = getMap(MAP_SLANTED_LO, MAP_SLANTED_HI, i);
			if (chs != null) {
				for (int ch : chs) {
					fonts[3].putCharacter(ch, g);
				}
			}
			chs = getMap(MAP_SMALL_LO, MAP_SMALL_HI, i);
			if (chs != null) {
				for (int ch : chs) {
					fonts[4].putCharacter(ch, g);
				}
			}
			chs = getMap(MAP_SCRIPT_LO, MAP_SCRIPT_HI, i);
			if (chs != null) {
				for (int ch : chs) {
					fonts[5].putCharacter(ch, g);
				}
			}
		}
		return fonts;
	}
	
	private static byte[] unpack(byte[] data) {
		byte[] nd = new byte[data.length*8];
		for (int s=0, d=0; s<data.length && d < nd.length; s++, d+=8) {
			nd[d+0] = (byte)((data[s] >> 7) & 1);
			nd[d+1] = (byte)((data[s] >> 6) & 1);
			nd[d+2] = (byte)((data[s] >> 5) & 1);
			nd[d+3] = (byte)((data[s] >> 4) & 1);
			nd[d+4] = (byte)((data[s] >> 3) & 1);
			nd[d+5] = (byte)((data[s] >> 2) & 1);
			nd[d+6] = (byte)((data[s] >> 1) & 1);
			nd[d+7] = (byte)((data[s] >> 0) & 1);
		}
		return nd;
	}
	
	private static int[] getMap(int[][] lo, int[][] hi, int i) {
		if (i < 512) return lo[i];
		else return hi[i - 512];
	}
	
	private static final int[][] MAP_SANS_LO = new int[][] {
		new int[]{9216},
		new int[]{9217},
		new int[]{9218},
		new int[]{9219},
		new int[]{9220},
		new int[]{9221},
		new int[]{9222},
		new int[]{9223},
		new int[]{9224},
		new int[]{9225},
		new int[]{9226},
		new int[]{9227},
		new int[]{9228},
		new int[]{9229},
		new int[]{9230},
		new int[]{9231},
		new int[]{9232},
		new int[]{9233},
		new int[]{9234},
		new int[]{9235},
		new int[]{9236},
		new int[]{9237},
		new int[]{9238},
		new int[]{9239},
		new int[]{9240},
		new int[]{9241},
		new int[]{9242},
		new int[]{9243},
		new int[]{9244},
		new int[]{9245},
		new int[]{9246},
		new int[]{9247},
		new int[]{32},
		new int[]{33},
		new int[]{34},
		new int[]{35},
		new int[]{36},
		new int[]{37},
		new int[]{38},
		new int[]{39},
		new int[]{40},
		new int[]{41},
		new int[]{42},
		new int[]{43},
		new int[]{44},
		new int[]{45,173},
		new int[]{46},
		new int[]{47},
		new int[]{48},
		new int[]{49},
		new int[]{50},
		new int[]{51,1047},
		new int[]{52},
		new int[]{53},
		new int[]{54},
		new int[]{55},
		new int[]{56},
		new int[]{57},
		new int[]{58},
		new int[]{59},
		new int[]{60},
		new int[]{61},
		new int[]{62},
		new int[]{63},
		new int[]{64},
		new int[]{65,913,1040},
		new int[]{66,914,1042},
		new int[]{67,1057},
		new int[]{68},
		new int[]{69,917,1045},
		new int[]{70},
		new int[]{71},
		new int[]{72,919,1053},
		new int[]{73,921},
		new int[]{74},
		new int[]{75,922,1050},
		new int[]{76},
		new int[]{77,924,1052},
		new int[]{78,925},
		new int[]{79,927,1054},
		new int[]{80,929,1056},
		new int[]{81},
		new int[]{82},
		new int[]{83},
		new int[]{84,932,1058},
		new int[]{85},
		new int[]{86},
		new int[]{87},
		new int[]{88,935,1061},
		new int[]{89,933},
		new int[]{90,918},
		new int[]{91},
		new int[]{92},
		new int[]{93},
		new int[]{94},
		new int[]{95},
		new int[]{96},
		new int[]{97,1072},
		new int[]{98},
		new int[]{99,1089},
		new int[]{100},
		new int[]{101,1077},
		new int[]{102},
		new int[]{103},
		new int[]{104},
		new int[]{105},
		new int[]{106},
		new int[]{107},
		new int[]{108},
		new int[]{109},
		new int[]{110,951},
		new int[]{111,959,1086},
		new int[]{112,1088},
		new int[]{113},
		new int[]{114},
		new int[]{115},
		new int[]{116},
		new int[]{117},
		new int[]{118},
		new int[]{119},
		new int[]{120,967,1093},
		new int[]{121,1091},
		new int[]{122},
		new int[]{123},
		new int[]{124},
		new int[]{125},
		new int[]{126},
		null,
		new int[]{8254},
		null,
		new int[]{8212},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{1075},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{127,63253},
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{63376},
		new int[]{8987},
		new int[]{63490},
		new int[]{63432},
		new int[]{63433},
		new int[]{63434},
		new int[]{63378},
		new int[]{63379},
		new int[]{63380},
		new int[]{63381},
		new int[]{8224},
		new int[]{176},
		new int[]{163},
		new int[]{162},
		new int[]{174},
		new int[]{169},
		new int[]{8482},
		new int[]{8230},
		new int[]{8984},
		new int[]{8997},
		new int[]{8679},
		new int[]{8593},
		new int[]{8595},
		new int[]{8592},
		new int[]{8594},
		new int[]{8864},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{915,1043},
		null,
		new int[]{945},
		new int[]{946},
		new int[]{947},
		new int[]{916,8710},
		new int[]{948},
		new int[]{949},
		new int[]{950},
		new int[]{958},
		new int[]{952},
		new int[]{920},
		new int[]{953},
		new int[]{954,1082},
		null,
		new int[]{923},
		new int[]{955},
		null,
		new int[]{181,956},
		new int[]{957},
		new int[]{926},
		null,
		new int[]{928,1055},
		new int[]{960,1087},
		new int[]{8719},
		new int[]{961},
		new int[]{8721},
		new int[]{931},
		new int[]{963},
		new int[]{964},
		new int[]{965},
		new int[]{966,1092},
		new int[]{934,1060},
		new int[]{248,216,8709},
		new int[]{936},
		new int[]{968},
		new int[]{937,8486},
		new int[]{969},
		new int[]{982},
		new int[]{8544},
		new int[]{8548},
		new int[]{8553},
		new int[]{8558},
		new int[]{8557},
		new int[]{8556},
		new int[]{8559},
		new int[]{8626,8629},
		new int[]{8996},
		new int[]{9099},
		new int[]{63382},
		new int[]{63383},
		new int[]{63397},
		new int[]{9788},
		new int[]{9681},
		new int[]{9652},
		new int[]{9662},
		new int[]{9666},
		new int[]{9656},
		new int[]{63416},
		new int[]{63417},
		new int[]{63249},
		null,
		null,
		null,
		null,
		new int[]{63435},
		new int[]{63436},
		new int[]{8677},
		new int[]{8676},
		new int[]{9645},
		new int[]{63419},
		new int[]{9644},
		new int[]{9679},
		new int[]{9675},
		new int[]{9632},
		new int[]{9633},
		new int[]{9712},
		new int[]{9636},
		new int[]{9641},
		new int[]{9673},
		new int[]{63415},
		new int[]{9677},
		new int[]{215},
		new int[]{247},
		new int[]{185},
		new int[]{178,8306},
		new int[]{179,8307},
		new int[]{8308},
		new int[]{8309},
		new int[]{8310},
		new int[]{8311},
		new int[]{8312},
		new int[]{8313},
		new int[]{8304,63327},
		new int[]{63313},
		new int[]{63314},
		new int[]{63317},
		new int[]{63321},
		new int[]{63326},
		new int[]{63331},
		new int[]{63332},
		new int[]{10003},
		new int[]{8730},
		new int[]{8731},
		new int[]{8319},
		new int[]{8321},
		new int[]{8322},
		new int[]{8323},
		new int[]{8324},
		new int[]{8325},
		new int[]{8326},
		new int[]{8327},
		new int[]{8328},
		new int[]{8329},
		new int[]{8320,63359},
		new int[]{8725},
		new int[]{8726},
		new int[]{172},
		new int[]{8747},
		new int[]{402},
		new int[]{63438},
		null,
		null,
		null,
		null,
		new int[]{8865},
		new int[]{8857},
		new int[]{63422},
		new int[]{9000},
		new int[]{8682},
		new int[]{8596},
		new int[]{8597},
		new int[]{63458},
		new int[]{8598},
		new int[]{8599},
		new int[]{8601},
		new int[]{8600},
		new int[]{63457},
		new int[]{63456},
		new int[]{63459},
		new int[]{196},
		new int[]{197},
		new int[]{199},
		new int[]{201},
		new int[]{209},
		new int[]{214},
		new int[]{220},
		new int[]{225},
		new int[]{224},
		new int[]{226},
		new int[]{227},
		new int[]{229},
		new int[]{231},
		new int[]{233},
		new int[]{232},
		new int[]{234},
		new int[]{235},
		new int[]{237,205},
		new int[]{236,204},
		new int[]{238,206},
		new int[]{239,207},
		new int[]{241},
		new int[]{243},
		new int[]{242},
		new int[]{244},
		new int[]{246},
		new int[]{245},
		new int[]{250},
		new int[]{249},
		new int[]{251},
		new int[]{252},
		new int[]{228},
		new int[]{8800},
		new int[]{198},
		new int[]{230},
		new int[]{338},
		new int[]{339},
		new int[]{8734},
		new int[]{177},
		new int[]{8804},
		new int[]{8805},
		new int[]{167},
		new int[]{182},
		new int[]{223},
		new int[]{8226},
		new int[]{165},
		new int[]{191},
		new int[]{161},
		new int[]{8776},
		new int[]{170},
		new int[]{186},
		new int[]{8211},
		new int[]{8220},
		new int[]{8221},
		new int[]{8216},
		new int[]{8217},
		new int[]{376},
		new int[]{255},
		new int[]{64258},
		new int[]{64257},
		new int[]{164},
		new int[]{8225},
		new int[]{8240},
		new int[]{160},
		new int[]{1041},
		null,
		new int[]{1073},
		new int[]{1074},
		null,
		new int[]{1044},
		new int[]{1076},
		new int[]{1046},
		new int[]{1078},
		new int[]{1079},
		new int[]{1048},
		null,
		new int[]{1080},
		null,
		new int[]{1051},
		null,
		new int[]{1083},
		null,
		new int[]{1059},
		new int[]{1062},
		new int[]{1094},
		null,
		null,
		new int[]{1063},
		null,
		new int[]{1095},
		null,
		new int[]{1049,1081},
		null,
		new int[]{1064},
		new int[]{1065},
		new int[]{1096},
		new int[]{1097},
		new int[]{1067},
		null,
		new int[]{1069},
		null,
		new int[]{1101},
		new int[]{1070},
		new int[]{1102},
		null,
		null,
		new int[]{1071},
		null,
		new int[]{9098},
		new int[]{63386},
		new int[]{63387},
		new int[]{63388},
		new int[]{171},
		new int[]{187},
		new int[]{63377},
		null,
		null,
		null,
		null,
		null,
		new int[]{9786},
		new int[]{9787},
		new int[]{9829},
		new int[]{9830,9670},
		new int[]{9824},
		new int[]{9827},
		new int[]{9794},
		new int[]{9792},
	};
	
	private static final int[][] MAP_SANS_HI = new int[][] {
		new int[]{189,8529},
		new int[]{8531},
		new int[]{8532},
		new int[]{188,8528},
		new int[]{190,8530},
		new int[]{8533},
		new int[]{8534},
		new int[]{8535},
		new int[]{8536},
		new int[]{8537},
		new int[]{8538},
		new int[]{8539},
		new int[]{8540},
		new int[]{8541},
		new int[]{8542},
		new int[]{63276},
		new int[]{63277},
		new int[]{63278},
		new int[]{63279},
		new int[]{63264},
		new int[]{63265},
		new int[]{63266},
		new int[]{63267},
		new int[]{63268},
		new int[]{63269},
		new int[]{63270},
		new int[]{63271},
		new int[]{63272},
		new int[]{63273},
		new int[]{63274},
		new int[]{63275},
		new int[]{63312},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{715},
		new int[]{180,714},
		new int[]{168},
		new int[]{710},
		new int[]{711,728},
		new int[]{730},
		new int[]{175,713},
		new int[]{732},
		new int[]{729},
		new int[]{733},
		new int[]{184},
		new int[]{731},
		new int[]{9601},
		new int[]{9615},
		new int[]{9620},
		new int[]{9621},
		new int[]{9472},
		null,
		null,
		null,
		null,
		new int[]{9532},
		new int[]{9496},
		new int[]{9492},
		new int[]{9488},
		new int[]{9484},
		null,
		null,
		null,
		null,
		new int[]{63440},
		new int[]{63442},
		new int[]{63446},
		new int[]{63444},
		new int[]{9565},
		new int[]{9562},
		new int[]{9559},
		new int[]{9556},
		new int[]{9552},
		new int[]{9580},
		new int[]{9553},
		new int[]{9500},
		new int[]{9508},
		new int[]{9516},
		new int[]{9524},
		new int[]{9568},
		new int[]{9571},
		new int[]{9574},
		new int[]{9577},
		new int[]{9474},
		new int[]{9499},
		new int[]{9490},
		new int[]{9493},
		new int[]{9473},
		new int[]{9475},
		new int[]{63447},
		new int[]{63443},
		new int[]{63441},
		new int[]{63445},
		null,
		new int[]{63420},
		new int[]{63421},
		new int[]{9586},
		new int[]{9585},
		new int[]{193},
		new int[]{192},
		new int[]{194},
		new int[]{195},
		new int[]{200},
		new int[]{202},
		new int[]{203},
		new int[]{211},
		new int[]{210},
		new int[]{212},
		new int[]{213},
		new int[]{218},
		new int[]{217},
		new int[]{219},
		new int[]{208},
		new int[]{240},
		new int[]{222},
		new int[]{254},
		new int[]{221},
		new int[]{253},
		new int[]{183},
		new int[]{166},
		new int[]{63234},
		new int[]{63235},
		new int[]{477,601},
		new int[]{9251},
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{63281},
		new int[]{63282},
		new int[]{63283},
		new int[]{63284},
		new int[]{63285},
		new int[]{63286},
		new int[]{63287},
		new int[]{63288,1085},
		new int[]{63289},
		new int[]{63290},
		new int[]{63291},
		new int[]{63292},
		new int[]{63293,1084},
		new int[]{63294},
		new int[]{63295},
		new int[]{63296},
		new int[]{63297},
		new int[]{63298},
		new int[]{63299},
		new int[]{63300,1090},
		new int[]{63301},
		new int[]{63302},
		new int[]{63303},
		new int[]{63304},
		new int[]{63305},
		new int[]{63306},
		new int[]{63232},
		new int[]{63233},
		new int[]{63252},
		new int[]{63250},
		new int[]{63743,63507},
		new int[]{63742,63506},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{63280},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{63263},
		new int[]{63260},
		new int[]{63262},
		new int[]{63261},
		new int[]{63347},
		new int[]{63348},
		new int[]{63350},
		new int[]{63351},
		new int[]{63352},
		new int[]{63354},
		new int[]{63355},
		new int[]{63356},
		new int[]{63357},
		new int[]{63360},
		new int[]{63361},
		new int[]{63362},
		new int[]{63365},
		new int[]{63366},
		new int[]{63367},
		new int[]{63368},
		new int[]{63369},
		new int[]{63370},
		new int[]{63315},
		new int[]{63316},
		new int[]{63318},
		new int[]{63319},
		new int[]{63320},
		new int[]{63322},
		new int[]{63323},
		new int[]{63324},
		new int[]{63325},
		new int[]{63328},
		new int[]{63329},
		new int[]{63330},
		new int[]{63333},
		new int[]{63334},
		new int[]{63335},
		new int[]{63336},
		new int[]{63337},
		new int[]{63338},
		new int[]{9581,63448},
		new int[]{9582,63450},
		new int[]{9584,63454},
		new int[]{9583,63452},
		new int[]{63449},
		new int[]{63453},
		new int[]{63455},
		new int[]{63451},
		new int[]{63472},
		new int[]{63429},
		new int[]{63428},
		new int[]{63431},
		new int[]{63430},
		new int[]{63385},
		new int[]{63384},
		new int[]{9604},
		new int[]{9612},
		new int[]{8992},
		new int[]{8993},
	};
	
	private static final int[][] MAP_SERIF_LO = new int[][] {
		new int[]{9216},
		new int[]{9217},
		new int[]{9218},
		new int[]{9219},
		new int[]{9220},
		new int[]{9221},
		new int[]{9222},
		new int[]{9223},
		new int[]{9224},
		new int[]{9225},
		new int[]{9226},
		new int[]{9227},
		new int[]{9228},
		new int[]{9229},
		new int[]{9230},
		new int[]{9231},
		new int[]{9232},
		new int[]{9233},
		new int[]{9234},
		new int[]{9235},
		new int[]{9236},
		new int[]{9237},
		new int[]{9238},
		new int[]{9239},
		new int[]{9240},
		new int[]{9241},
		new int[]{9242},
		new int[]{9243},
		new int[]{9244},
		new int[]{9245},
		new int[]{9246},
		new int[]{9247},
		new int[]{32},
		new int[]{33},
		new int[]{34},
		new int[]{35},
		new int[]{36},
		new int[]{37},
		new int[]{38},
		new int[]{39},
		new int[]{40},
		new int[]{41},
		new int[]{42},
		new int[]{43},
		new int[]{44},
		new int[]{45,173},
		new int[]{46},
		new int[]{47},
		new int[]{48},
		new int[]{49},
		new int[]{50},
		new int[]{51,1047},
		new int[]{52},
		new int[]{53},
		new int[]{54},
		new int[]{55},
		new int[]{56},
		new int[]{57},
		new int[]{58},
		new int[]{59},
		new int[]{60},
		new int[]{61},
		new int[]{62},
		new int[]{63},
		new int[]{64},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{91},
		new int[]{92},
		new int[]{93},
		new int[]{94},
		new int[]{95},
		new int[]{96},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{123},
		new int[]{124},
		new int[]{125},
		new int[]{126},
		null,
		new int[]{8254},
		null,
		new int[]{8212},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{1075},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{127,63253},
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{63376},
		new int[]{8987},
		new int[]{63490},
		new int[]{63432},
		new int[]{63433},
		new int[]{63434},
		new int[]{63378},
		new int[]{63379},
		new int[]{63380},
		new int[]{63381},
		new int[]{8224},
		new int[]{176},
		new int[]{163},
		new int[]{162},
		new int[]{174},
		new int[]{169},
		new int[]{8482},
		new int[]{8230},
		new int[]{8984},
		new int[]{8997},
		new int[]{8679},
		new int[]{8593},
		new int[]{8595},
		new int[]{8592},
		new int[]{8594},
		new int[]{8864},
		new int[]{65,913,1040},
		new int[]{66,914,1042},
		new int[]{67,1057},
		new int[]{68},
		new int[]{69,917,1045},
		new int[]{70},
		new int[]{71},
		new int[]{72,919,1053},
		new int[]{73,921},
		new int[]{74},
		new int[]{75,922,1050},
		new int[]{76},
		new int[]{77,924,1052},
		new int[]{78,925},
		new int[]{79,927,1054},
		new int[]{80,929,1056},
		new int[]{81},
		new int[]{82},
		new int[]{83},
		new int[]{84,932,1058},
		new int[]{85},
		new int[]{86},
		new int[]{87},
		new int[]{88,935,1061},
		new int[]{89,933},
		new int[]{90,918},
		new int[]{97,1072},
		new int[]{98},
		new int[]{99,1089},
		new int[]{100},
		new int[]{101,1077},
		new int[]{102},
		new int[]{103},
		new int[]{104},
		new int[]{105},
		new int[]{106},
		new int[]{107},
		new int[]{108},
		new int[]{109},
		new int[]{110,951},
		new int[]{111,959,1086},
		new int[]{112,1088},
		new int[]{113},
		new int[]{114},
		new int[]{115},
		new int[]{116},
		new int[]{117},
		new int[]{118},
		new int[]{119},
		new int[]{120,967,1093},
		new int[]{121,1091},
		new int[]{122},
		null,
		new int[]{915,1043},
		new int[]{945},
		new int[]{946},
		new int[]{947},
		new int[]{916,8710},
		new int[]{948},
		new int[]{949},
		new int[]{950},
		new int[]{958},
		new int[]{952},
		new int[]{920},
		new int[]{953},
		new int[]{954,1082},
		new int[]{923},
		null,
		null,
		new int[]{955},
		new int[]{181,956},
		new int[]{957},
		null,
		new int[]{926},
		null,
		new int[]{960,1087},
		new int[]{928,1055,8719},
		new int[]{961},
		new int[]{931,8721},
		null,
		new int[]{963},
		new int[]{964},
		new int[]{965},
		new int[]{966,1092},
		new int[]{934,1060},
		new int[]{248,216,8709},
		new int[]{936},
		new int[]{968},
		new int[]{937,8486},
		new int[]{969},
		new int[]{982},
		new int[]{8544},
		new int[]{8548},
		new int[]{8553},
		new int[]{8558},
		new int[]{8557},
		new int[]{8556},
		new int[]{8559},
		new int[]{8626,8629},
		new int[]{8996},
		new int[]{9099},
		new int[]{63382},
		new int[]{63383},
		new int[]{63397},
		new int[]{9788},
		new int[]{9681},
		new int[]{9652},
		new int[]{9662},
		new int[]{9666},
		new int[]{9656},
		new int[]{63416},
		new int[]{63417},
		new int[]{63249},
		null,
		null,
		null,
		null,
		new int[]{63435},
		new int[]{63436},
		new int[]{8677},
		new int[]{8676},
		new int[]{9645},
		new int[]{63419},
		new int[]{9644},
		new int[]{9679},
		new int[]{9675},
		new int[]{9632},
		new int[]{9633},
		new int[]{9712},
		new int[]{9636},
		new int[]{9641},
		new int[]{9673},
		new int[]{63415},
		new int[]{9677},
		new int[]{215},
		new int[]{247},
		new int[]{185},
		new int[]{178,8306},
		new int[]{179,8307},
		new int[]{8308},
		new int[]{8309},
		new int[]{8310},
		new int[]{8311},
		new int[]{8312},
		new int[]{8313},
		new int[]{8304,63327},
		new int[]{63313},
		new int[]{63314},
		new int[]{63317},
		new int[]{63321},
		new int[]{63326},
		new int[]{63331},
		new int[]{63332},
		new int[]{10003},
		new int[]{8730},
		new int[]{8731},
		new int[]{8319},
		new int[]{8321},
		new int[]{8322},
		new int[]{8323},
		new int[]{8324},
		new int[]{8325},
		new int[]{8326},
		new int[]{8327},
		new int[]{8328},
		new int[]{8329},
		new int[]{8320,63359},
		new int[]{8725},
		new int[]{8726},
		new int[]{172},
		new int[]{8747},
		new int[]{402},
		new int[]{63438},
		null,
		null,
		null,
		null,
		new int[]{8865},
		new int[]{8857},
		new int[]{63422},
		new int[]{9000},
		new int[]{8682},
		new int[]{8596},
		new int[]{8597},
		new int[]{63458},
		new int[]{8598},
		new int[]{8599},
		new int[]{8601},
		new int[]{8600},
		new int[]{63457},
		new int[]{63456},
		new int[]{63459},
		new int[]{196},
		new int[]{197},
		new int[]{199},
		new int[]{201},
		new int[]{209},
		new int[]{214},
		new int[]{220},
		new int[]{225},
		new int[]{224},
		new int[]{226},
		new int[]{227},
		new int[]{229},
		new int[]{231},
		new int[]{233},
		new int[]{232},
		new int[]{234},
		new int[]{235},
		new int[]{237,205},
		new int[]{236,204},
		new int[]{238,206},
		new int[]{239,207},
		new int[]{241},
		new int[]{243},
		new int[]{242},
		new int[]{244},
		new int[]{246},
		new int[]{245},
		new int[]{250},
		new int[]{249},
		new int[]{251},
		new int[]{252},
		new int[]{228},
		new int[]{8800},
		new int[]{198},
		new int[]{230},
		new int[]{338},
		new int[]{339},
		new int[]{8734},
		new int[]{177},
		new int[]{8804},
		new int[]{8805},
		new int[]{167},
		new int[]{182},
		new int[]{223},
		new int[]{8226},
		new int[]{165},
		new int[]{191},
		new int[]{161},
		new int[]{8776},
		new int[]{170},
		new int[]{186},
		new int[]{8211},
		new int[]{8220},
		new int[]{8221},
		new int[]{8216},
		new int[]{8217},
		new int[]{376},
		new int[]{255},
		new int[]{64258},
		new int[]{64257},
		new int[]{164},
		new int[]{8225},
		new int[]{8240},
		new int[]{160},
		null,
		new int[]{1041},
		new int[]{1073},
		null,
		new int[]{1074},
		new int[]{1044},
		new int[]{1076},
		new int[]{1046},
		new int[]{1078},
		new int[]{1079},
		null,
		new int[]{1048},
		null,
		new int[]{1080},
		null,
		new int[]{1051},
		null,
		new int[]{1083},
		new int[]{1059},
		null,
		null,
		new int[]{1062},
		new int[]{1094},
		null,
		new int[]{1063},
		null,
		new int[]{1095},
		null,
		new int[]{1049,1081},
		new int[]{1064},
		new int[]{1065},
		new int[]{1096},
		new int[]{1097},
		null,
		new int[]{1067},
		null,
		new int[]{1069},
		new int[]{1101},
		null,
		null,
		new int[]{1070},
		new int[]{1102},
		null,
		new int[]{1071},
		new int[]{9098},
		new int[]{63386},
		new int[]{63387},
		new int[]{63388},
		new int[]{171},
		new int[]{187},
		new int[]{63377},
		null,
		null,
		null,
		null,
		null,
		new int[]{9786},
		new int[]{9787},
		new int[]{9829},
		new int[]{9830,9670},
		new int[]{9824},
		new int[]{9827},
		new int[]{9794},
		new int[]{9792},
	};
	
	private static final int[][] MAP_SERIF_HI = new int[][] {
		new int[]{189,8529},
		new int[]{8531},
		new int[]{8532},
		new int[]{188,8528},
		new int[]{190,8530},
		new int[]{8533},
		new int[]{8534},
		new int[]{8535},
		new int[]{8536},
		new int[]{8537},
		new int[]{8538},
		new int[]{8539},
		new int[]{8540},
		new int[]{8541},
		new int[]{8542},
		new int[]{63276},
		new int[]{63277},
		new int[]{63278},
		new int[]{63279},
		new int[]{63264},
		new int[]{63265},
		new int[]{63266},
		new int[]{63267},
		new int[]{63268},
		new int[]{63269},
		new int[]{63270},
		new int[]{63271},
		new int[]{63272},
		new int[]{63273},
		new int[]{63274},
		new int[]{63275},
		new int[]{63312},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{715},
		new int[]{180,714},
		new int[]{168},
		new int[]{710},
		new int[]{711,728},
		new int[]{730},
		new int[]{175,713},
		new int[]{732},
		new int[]{729},
		new int[]{733},
		new int[]{184},
		new int[]{731},
		new int[]{9601},
		new int[]{9615},
		new int[]{9620},
		new int[]{9621},
		new int[]{9472},
		null,
		null,
		null,
		null,
		new int[]{9532},
		new int[]{9496},
		new int[]{9492},
		new int[]{9488},
		new int[]{9484},
		null,
		null,
		null,
		null,
		new int[]{63440},
		new int[]{63442},
		new int[]{63446},
		new int[]{63444},
		new int[]{9565},
		new int[]{9562},
		new int[]{9559},
		new int[]{9556},
		new int[]{9552},
		new int[]{9580},
		new int[]{9553},
		new int[]{9500},
		new int[]{9508},
		new int[]{9516},
		new int[]{9524},
		new int[]{9568},
		new int[]{9571},
		new int[]{9574},
		new int[]{9577},
		new int[]{9474},
		new int[]{9499},
		new int[]{9490},
		new int[]{9493},
		new int[]{9473},
		new int[]{9475},
		new int[]{63447},
		new int[]{63443},
		new int[]{63441},
		new int[]{63445},
		null,
		new int[]{63420},
		new int[]{63421},
		new int[]{9586},
		new int[]{9585},
		new int[]{193},
		new int[]{192},
		new int[]{194},
		new int[]{195},
		new int[]{200},
		new int[]{202},
		new int[]{203},
		new int[]{211},
		new int[]{210},
		new int[]{212},
		new int[]{213},
		new int[]{218},
		new int[]{217},
		new int[]{219},
		new int[]{208},
		new int[]{240},
		new int[]{222},
		new int[]{254},
		new int[]{221},
		new int[]{253},
		new int[]{183},
		new int[]{166},
		new int[]{63234},
		new int[]{63235},
		new int[]{477,601},
		new int[]{9251},
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{63281},
		new int[]{63282},
		new int[]{63283},
		new int[]{63284},
		new int[]{63285},
		new int[]{63286},
		new int[]{63287},
		new int[]{63288,1085},
		new int[]{63289},
		new int[]{63290},
		new int[]{63291},
		new int[]{63292},
		new int[]{63293,1084},
		new int[]{63294},
		new int[]{63295},
		new int[]{63296},
		new int[]{63297},
		new int[]{63298},
		new int[]{63299},
		new int[]{63300,1090},
		new int[]{63301},
		new int[]{63302},
		new int[]{63303},
		new int[]{63304},
		new int[]{63305},
		new int[]{63306},
		new int[]{63232},
		new int[]{63233},
		new int[]{63252},
		new int[]{63250},
		new int[]{63743,63507},
		new int[]{63742,63506},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{63280},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{63263},
		new int[]{63260},
		new int[]{63262},
		new int[]{63261},
		new int[]{63347},
		new int[]{63348},
		new int[]{63350},
		new int[]{63351},
		new int[]{63352},
		new int[]{63354},
		new int[]{63355},
		new int[]{63356},
		new int[]{63357},
		new int[]{63360},
		new int[]{63361},
		new int[]{63362},
		new int[]{63365},
		new int[]{63366},
		new int[]{63367},
		new int[]{63368},
		new int[]{63369},
		new int[]{63370},
		new int[]{63315},
		new int[]{63316},
		new int[]{63318},
		new int[]{63319},
		new int[]{63320},
		new int[]{63322},
		new int[]{63323},
		new int[]{63324},
		new int[]{63325},
		new int[]{63328},
		new int[]{63329},
		new int[]{63330},
		new int[]{63333},
		new int[]{63334},
		new int[]{63335},
		new int[]{63336},
		new int[]{63337},
		new int[]{63338},
		new int[]{9581,63448},
		new int[]{9582,63450},
		new int[]{9584,63454},
		new int[]{9583,63452},
		new int[]{63449},
		new int[]{63453},
		new int[]{63455},
		new int[]{63451},
		new int[]{63472},
		new int[]{63429},
		new int[]{63428},
		new int[]{63431},
		new int[]{63430},
		new int[]{63385},
		new int[]{63384},
		new int[]{9604},
		new int[]{9612},
		new int[]{8992},
		new int[]{8993},
	};
	
	private static final int[][] MAP_SOLID_LO = new int[][] {
		new int[]{9216},
		new int[]{9217},
		new int[]{9218},
		new int[]{9219},
		new int[]{9220},
		new int[]{9221},
		new int[]{9222},
		new int[]{9223},
		new int[]{9224},
		new int[]{9225},
		new int[]{9226},
		new int[]{9227},
		new int[]{9228},
		new int[]{9229},
		new int[]{9230},
		new int[]{9231},
		new int[]{9232},
		new int[]{9233},
		new int[]{9234},
		new int[]{9235},
		new int[]{9236},
		new int[]{9237},
		new int[]{9238},
		new int[]{9239},
		new int[]{9240},
		new int[]{9241},
		new int[]{9242},
		new int[]{9243},
		new int[]{9244},
		new int[]{9245},
		new int[]{9246},
		new int[]{9247},
		new int[]{32},
		null,
		null,
		new int[]{35},
		new int[]{36},
		null,
		new int[]{38},
		null,
		null,
		null,
		new int[]{42},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{1047},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{64},
		new int[]{913,1040},
		new int[]{914,1042},
		new int[]{1057},
		null,
		new int[]{917,1045},
		null,
		null,
		new int[]{919,1053},
		new int[]{921},
		null,
		new int[]{922,1050},
		null,
		new int[]{924,1052},
		new int[]{925},
		new int[]{927,1054},
		new int[]{929,1056},
		null,
		null,
		null,
		new int[]{932,1058},
		null,
		null,
		null,
		new int[]{935,1061},
		new int[]{933},
		new int[]{918},
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{1072},
		null,
		new int[]{1089},
		null,
		new int[]{1077},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{951},
		new int[]{959,1086},
		new int[]{1088},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{967,1093},
		new int[]{1091},
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{8254},
		null,
		new int[]{8212},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{1075},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{127,63253},
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{63376},
		new int[]{8987},
		new int[]{63490},
		new int[]{63432},
		new int[]{63433},
		new int[]{63434},
		new int[]{63378},
		new int[]{63379},
		new int[]{63380},
		new int[]{63381},
		new int[]{8224},
		new int[]{176},
		new int[]{163},
		new int[]{162},
		new int[]{174},
		new int[]{169},
		new int[]{8482},
		new int[]{8230},
		new int[]{8984},
		new int[]{8997},
		new int[]{8679},
		new int[]{8593},
		new int[]{8595},
		new int[]{8592},
		new int[]{8594},
		new int[]{8864},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{915,1043},
		null,
		new int[]{945},
		new int[]{946},
		new int[]{947},
		new int[]{916,8710},
		new int[]{948},
		new int[]{949},
		new int[]{950},
		new int[]{958},
		new int[]{952},
		new int[]{920},
		new int[]{953},
		new int[]{954,1082},
		null,
		new int[]{923},
		new int[]{955},
		null,
		new int[]{181,956},
		new int[]{957},
		new int[]{926},
		null,
		new int[]{928,1055},
		new int[]{960,1087},
		new int[]{8719},
		new int[]{961},
		new int[]{8721},
		new int[]{931},
		new int[]{963},
		new int[]{964},
		new int[]{965},
		new int[]{966,1092},
		new int[]{934,1060},
		new int[]{248,216,8709},
		new int[]{936},
		new int[]{968},
		new int[]{937,8486},
		new int[]{969},
		new int[]{982},
		new int[]{8544},
		new int[]{8548},
		new int[]{8553},
		new int[]{8558},
		new int[]{8557},
		new int[]{8556},
		new int[]{8559},
		new int[]{8626,8629},
		new int[]{8996},
		new int[]{9099},
		new int[]{63382},
		new int[]{63383},
		new int[]{63397},
		new int[]{9788},
		new int[]{9681},
		new int[]{9652},
		new int[]{9662},
		new int[]{9666},
		new int[]{9656},
		new int[]{63416},
		new int[]{63417},
		new int[]{63249},
		null,
		null,
		null,
		null,
		new int[]{63435},
		new int[]{63436},
		new int[]{8677},
		new int[]{8676},
		new int[]{9645},
		new int[]{63419},
		new int[]{9644},
		new int[]{9679},
		new int[]{9675},
		new int[]{9632},
		new int[]{9633},
		new int[]{9712},
		new int[]{9636},
		new int[]{9641},
		new int[]{9673},
		new int[]{63415},
		new int[]{9677},
		new int[]{215},
		new int[]{247},
		new int[]{185},
		new int[]{178,8306},
		new int[]{179,8307},
		new int[]{8308},
		new int[]{8309},
		new int[]{8310},
		new int[]{8311},
		new int[]{8312},
		new int[]{8313},
		new int[]{8304,63327},
		new int[]{63313},
		new int[]{63314},
		new int[]{63317},
		new int[]{63321},
		new int[]{63326},
		new int[]{63331},
		new int[]{63332},
		new int[]{10003},
		new int[]{8730},
		new int[]{8731},
		new int[]{8319},
		new int[]{8321},
		new int[]{8322},
		new int[]{8323},
		new int[]{8324},
		new int[]{8325},
		new int[]{8326},
		new int[]{8327},
		new int[]{8328},
		new int[]{8329},
		new int[]{8320,63359},
		new int[]{8725},
		new int[]{8726},
		new int[]{172},
		new int[]{8747},
		new int[]{402},
		new int[]{63438},
		null,
		null,
		null,
		null,
		new int[]{8865},
		new int[]{8857},
		new int[]{63422},
		new int[]{9000},
		new int[]{8682},
		new int[]{8596},
		new int[]{8597},
		new int[]{63458},
		new int[]{8598},
		new int[]{8599},
		new int[]{8601},
		new int[]{8600},
		new int[]{63457},
		new int[]{63456},
		new int[]{63459},
		new int[]{196},
		new int[]{197},
		new int[]{199},
		new int[]{201},
		new int[]{209},
		new int[]{214},
		new int[]{220},
		new int[]{225},
		new int[]{224},
		new int[]{226},
		new int[]{227},
		new int[]{229},
		new int[]{231},
		new int[]{233},
		new int[]{232},
		new int[]{234},
		new int[]{235},
		new int[]{237,205},
		new int[]{236,204},
		new int[]{238,206},
		new int[]{239,207},
		new int[]{241},
		new int[]{243},
		new int[]{242},
		new int[]{244},
		new int[]{246},
		new int[]{245},
		new int[]{250},
		new int[]{249},
		new int[]{251},
		new int[]{252},
		new int[]{228},
		new int[]{8800},
		new int[]{198},
		new int[]{230},
		new int[]{338},
		new int[]{339},
		new int[]{8734},
		new int[]{177},
		new int[]{8804},
		new int[]{8805},
		new int[]{167},
		new int[]{182},
		new int[]{223},
		new int[]{8226},
		new int[]{165},
		new int[]{191},
		new int[]{161},
		new int[]{8776},
		new int[]{170},
		new int[]{186},
		new int[]{8211},
		new int[]{8220},
		new int[]{8221},
		new int[]{8216},
		new int[]{8217},
		new int[]{376},
		new int[]{255},
		new int[]{64258},
		new int[]{64257},
		new int[]{164},
		new int[]{8225},
		new int[]{8240},
		new int[]{160},
		new int[]{1041},
		null,
		new int[]{1073},
		new int[]{1074},
		null,
		new int[]{1044},
		new int[]{1076},
		new int[]{1046},
		new int[]{1078},
		new int[]{1079},
		new int[]{1048},
		null,
		new int[]{1080},
		null,
		new int[]{1051},
		null,
		new int[]{1083},
		null,
		new int[]{1059},
		new int[]{1062},
		new int[]{1094},
		null,
		null,
		new int[]{1063},
		null,
		new int[]{1095},
		null,
		new int[]{1049,1081},
		null,
		new int[]{1064},
		new int[]{1065},
		new int[]{1096},
		new int[]{1097},
		new int[]{1067},
		null,
		new int[]{1069},
		null,
		new int[]{1101},
		new int[]{1070},
		new int[]{1102},
		null,
		null,
		new int[]{1071},
		null,
		new int[]{9098},
		new int[]{63386},
		new int[]{63387},
		new int[]{63388},
		new int[]{171},
		new int[]{187},
		new int[]{63377},
		null,
		null,
		null,
		null,
		null,
		new int[]{9786},
		new int[]{9787},
		new int[]{9829},
		new int[]{9830,9670},
		new int[]{9824},
		new int[]{9827},
		new int[]{9794},
		new int[]{9792},
	};
	
	private static final int[][] MAP_SOLID_HI = new int[][] {
		new int[]{189,8529},
		new int[]{8531},
		new int[]{8532},
		new int[]{188,8528},
		new int[]{190,8530},
		new int[]{8533},
		new int[]{8534},
		new int[]{8535},
		new int[]{8536},
		new int[]{8537},
		new int[]{8538},
		new int[]{8539},
		new int[]{8540},
		new int[]{8541},
		new int[]{8542},
		new int[]{63276},
		new int[]{63277},
		new int[]{63278},
		new int[]{63279},
		new int[]{63264},
		new int[]{63265},
		new int[]{63266},
		new int[]{63267},
		new int[]{63268},
		new int[]{63269},
		new int[]{63270},
		new int[]{63271},
		new int[]{63272},
		new int[]{63273},
		new int[]{63274},
		new int[]{63275},
		new int[]{63312},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{715},
		new int[]{180,714},
		new int[]{168},
		new int[]{710},
		new int[]{711,728},
		new int[]{730},
		new int[]{175,713},
		new int[]{732},
		new int[]{729},
		new int[]{733},
		new int[]{184},
		new int[]{731},
		new int[]{9601},
		new int[]{9615},
		new int[]{9620},
		new int[]{9621},
		new int[]{9472},
		null,
		null,
		null,
		null,
		new int[]{9532},
		new int[]{9496},
		new int[]{9492},
		new int[]{9488},
		new int[]{9484},
		null,
		null,
		null,
		null,
		new int[]{63440},
		new int[]{63442},
		new int[]{63446},
		new int[]{63444},
		new int[]{9565},
		new int[]{9562},
		new int[]{9559},
		new int[]{9556},
		new int[]{9552},
		new int[]{9580},
		new int[]{9553},
		new int[]{9500},
		new int[]{9508},
		new int[]{9516},
		new int[]{9524},
		new int[]{9568},
		new int[]{9571},
		new int[]{9574},
		new int[]{9577},
		new int[]{9474},
		new int[]{9499},
		new int[]{9490},
		new int[]{9493},
		new int[]{9473},
		new int[]{9475},
		new int[]{63447},
		new int[]{63443},
		new int[]{63441},
		new int[]{63445},
		null,
		new int[]{63420},
		new int[]{63421},
		new int[]{9586},
		new int[]{9585},
		new int[]{193},
		new int[]{192},
		new int[]{194},
		new int[]{195},
		new int[]{200},
		new int[]{202},
		new int[]{203},
		new int[]{211},
		new int[]{210},
		new int[]{212},
		new int[]{213},
		new int[]{218},
		new int[]{217},
		new int[]{219},
		new int[]{208},
		new int[]{240},
		new int[]{222},
		new int[]{254},
		new int[]{221},
		new int[]{253},
		new int[]{183},
		new int[]{166},
		new int[]{63234},
		new int[]{63235},
		new int[]{477,601},
		new int[]{9251},
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{63281},
		new int[]{63282},
		new int[]{63283},
		new int[]{63284},
		new int[]{63285},
		new int[]{63286},
		new int[]{63287},
		new int[]{63288,1085},
		new int[]{63289},
		new int[]{63290},
		new int[]{63291},
		new int[]{63292},
		new int[]{63293,1084},
		new int[]{63294},
		new int[]{63295},
		new int[]{63296},
		new int[]{63297},
		new int[]{63298},
		new int[]{63299},
		new int[]{63300,1090},
		new int[]{63301},
		new int[]{63302},
		new int[]{63303},
		new int[]{63304},
		new int[]{63305},
		new int[]{63306},
		new int[]{63232},
		new int[]{63233},
		new int[]{63252},
		new int[]{63250},
		new int[]{63743,63507},
		new int[]{63742,63506},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{63280},
		new int[]{33},
		new int[]{34},
		new int[]{37},
		new int[]{39},
		new int[]{40},
		new int[]{41},
		new int[]{43},
		new int[]{44},
		new int[]{45,173},
		new int[]{46},
		new int[]{47},
		new int[]{48},
		new int[]{49},
		new int[]{50},
		new int[]{51},
		new int[]{52},
		new int[]{53},
		new int[]{54},
		new int[]{55},
		new int[]{56},
		new int[]{57},
		new int[]{58},
		new int[]{59},
		new int[]{60},
		new int[]{61},
		new int[]{62},
		new int[]{63},
		new int[]{65},
		new int[]{66},
		new int[]{67},
		new int[]{68},
		new int[]{69},
		new int[]{70},
		new int[]{71},
		new int[]{72},
		new int[]{73},
		new int[]{74},
		new int[]{75},
		new int[]{76},
		new int[]{77},
		new int[]{78},
		new int[]{79},
		new int[]{80},
		new int[]{81},
		new int[]{82},
		new int[]{83},
		new int[]{84},
		new int[]{85},
		new int[]{86},
		new int[]{87},
		new int[]{88},
		new int[]{89},
		new int[]{90},
		new int[]{91},
		new int[]{92},
		new int[]{93},
		new int[]{94},
		new int[]{95},
		new int[]{96},
		new int[]{97},
		new int[]{98},
		new int[]{99},
		new int[]{100},
		new int[]{101},
		new int[]{102},
		new int[]{103},
		new int[]{104},
		new int[]{105},
		new int[]{106},
		new int[]{107},
		new int[]{108},
		new int[]{109},
		new int[]{110},
		new int[]{111},
		new int[]{112},
		new int[]{113},
		new int[]{114},
		new int[]{115},
		new int[]{116},
		new int[]{117},
		new int[]{118},
		new int[]{119},
		new int[]{120},
		new int[]{121},
		new int[]{122},
		new int[]{123},
		new int[]{124},
		new int[]{125},
		new int[]{126},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{63263},
		new int[]{63260},
		new int[]{63262},
		new int[]{63261},
		new int[]{63347},
		new int[]{63348},
		new int[]{63350},
		new int[]{63351},
		new int[]{63352},
		new int[]{63354},
		new int[]{63355},
		new int[]{63356},
		new int[]{63357},
		new int[]{63360},
		new int[]{63361},
		new int[]{63362},
		new int[]{63365},
		new int[]{63366},
		new int[]{63367},
		new int[]{63368},
		new int[]{63369},
		new int[]{63370},
		new int[]{63315},
		new int[]{63316},
		new int[]{63318},
		new int[]{63319},
		new int[]{63320},
		new int[]{63322},
		new int[]{63323},
		new int[]{63324},
		new int[]{63325},
		new int[]{63328},
		new int[]{63329},
		new int[]{63330},
		new int[]{63333},
		new int[]{63334},
		new int[]{63335},
		new int[]{63336},
		new int[]{63337},
		new int[]{63338},
		new int[]{9581,63448},
		new int[]{9582,63450},
		new int[]{9584,63454},
		new int[]{9583,63452},
		new int[]{63449},
		new int[]{63453},
		new int[]{63455},
		new int[]{63451},
		new int[]{63472},
		new int[]{63429},
		new int[]{63428},
		new int[]{63431},
		new int[]{63430},
		new int[]{63385},
		new int[]{63384},
		new int[]{9604},
		new int[]{9612},
		new int[]{8992},
		new int[]{8993},
	};
	
	private static final int[][] MAP_SLANTED_LO = new int[][] {
		new int[]{9216},
		new int[]{9217},
		new int[]{9218},
		new int[]{9219},
		new int[]{9220},
		new int[]{9221},
		new int[]{9222},
		new int[]{9223},
		new int[]{9224},
		new int[]{9225},
		new int[]{9226},
		new int[]{9227},
		new int[]{9228},
		new int[]{9229},
		new int[]{9230},
		new int[]{9231},
		new int[]{9232},
		new int[]{9233},
		new int[]{9234},
		new int[]{9235},
		new int[]{9236},
		new int[]{9237},
		new int[]{9238},
		new int[]{9239},
		new int[]{9240},
		new int[]{9241},
		new int[]{9242},
		new int[]{9243},
		new int[]{9244},
		new int[]{9245},
		new int[]{9246},
		new int[]{9247},
		new int[]{32},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{1047},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{913,1040},
		new int[]{914,1042},
		new int[]{1057},
		null,
		new int[]{917,1045},
		null,
		null,
		new int[]{919,1053},
		new int[]{921},
		null,
		new int[]{922,1050},
		null,
		new int[]{924,1052},
		new int[]{925},
		new int[]{927,1054},
		new int[]{929,1056},
		null,
		null,
		null,
		new int[]{932,1058},
		null,
		null,
		null,
		new int[]{935,1061},
		new int[]{933},
		new int[]{918},
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{1072},
		null,
		new int[]{1089},
		null,
		new int[]{1077},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{951},
		new int[]{959,1086},
		new int[]{1088},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{967,1093},
		new int[]{1091},
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{8254},
		null,
		new int[]{8212},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{1075},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{63376},
		new int[]{8987},
		new int[]{63490},
		new int[]{63432},
		new int[]{63433},
		new int[]{63434},
		new int[]{63378},
		new int[]{63379},
		new int[]{63380},
		new int[]{63381},
		new int[]{8224},
		new int[]{176},
		new int[]{163},
		new int[]{162},
		new int[]{174},
		new int[]{169},
		new int[]{8482},
		new int[]{8230},
		new int[]{8984},
		new int[]{8997},
		new int[]{8679},
		new int[]{8593},
		new int[]{8595},
		new int[]{8592},
		new int[]{8594},
		new int[]{8864},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{915,1043},
		null,
		new int[]{945},
		new int[]{946},
		new int[]{947},
		new int[]{916,8710},
		new int[]{948},
		new int[]{949},
		new int[]{950},
		new int[]{958},
		new int[]{952},
		new int[]{920},
		new int[]{953},
		new int[]{954,1082},
		null,
		new int[]{923},
		new int[]{955},
		null,
		new int[]{181,956},
		new int[]{957},
		new int[]{926},
		null,
		new int[]{928,1055},
		new int[]{960,1087},
		new int[]{8719},
		new int[]{961},
		new int[]{8721},
		new int[]{931},
		new int[]{963},
		new int[]{964},
		new int[]{965},
		new int[]{966,1092},
		new int[]{934,1060},
		new int[]{248,216,8709},
		new int[]{936},
		new int[]{968},
		new int[]{937,8486},
		new int[]{969},
		new int[]{982},
		new int[]{8544},
		new int[]{8548},
		new int[]{8553},
		new int[]{8558},
		new int[]{8557},
		new int[]{8556},
		new int[]{8559},
		new int[]{8626,8629},
		new int[]{8996},
		new int[]{9099},
		new int[]{63382},
		new int[]{63383},
		new int[]{63397},
		new int[]{9788},
		new int[]{9681},
		new int[]{9652},
		new int[]{9662},
		new int[]{9666},
		new int[]{9656},
		new int[]{63416},
		new int[]{63417},
		new int[]{63249},
		null,
		null,
		null,
		null,
		new int[]{63435},
		new int[]{63436},
		new int[]{8677},
		new int[]{8676},
		new int[]{9645},
		new int[]{63419},
		new int[]{9644},
		new int[]{9679},
		new int[]{9675},
		new int[]{9632},
		new int[]{9633},
		new int[]{9712},
		new int[]{9636},
		new int[]{9641},
		new int[]{9673},
		new int[]{63415},
		new int[]{9677},
		new int[]{215},
		new int[]{247},
		new int[]{185},
		new int[]{178,8306},
		new int[]{179,8307},
		new int[]{8308},
		new int[]{8309},
		new int[]{8310},
		new int[]{8311},
		new int[]{8312},
		new int[]{8313},
		new int[]{8304,63327},
		new int[]{63313},
		new int[]{63314},
		new int[]{63317},
		new int[]{63321},
		new int[]{63326},
		new int[]{63331},
		new int[]{63332},
		new int[]{10003},
		new int[]{8730},
		new int[]{8731},
		new int[]{8319},
		new int[]{8321},
		new int[]{8322},
		new int[]{8323},
		new int[]{8324},
		new int[]{8325},
		new int[]{8326},
		new int[]{8327},
		new int[]{8328},
		new int[]{8329},
		new int[]{8320,63359},
		new int[]{8725},
		new int[]{8726},
		new int[]{172},
		new int[]{8747},
		new int[]{402},
		new int[]{63438},
		null,
		null,
		null,
		null,
		new int[]{8865},
		new int[]{8857},
		new int[]{63422},
		new int[]{9000},
		new int[]{8682},
		new int[]{8596},
		new int[]{8597},
		new int[]{63458},
		new int[]{8598},
		new int[]{8599},
		new int[]{8601},
		new int[]{8600},
		new int[]{63457},
		new int[]{63456},
		new int[]{63459},
		new int[]{196},
		new int[]{197},
		new int[]{199},
		new int[]{201},
		new int[]{209},
		new int[]{214},
		new int[]{220},
		new int[]{225},
		new int[]{224},
		new int[]{226},
		new int[]{227},
		new int[]{229},
		new int[]{231},
		new int[]{233},
		new int[]{232},
		new int[]{234},
		new int[]{235},
		new int[]{237,205},
		new int[]{236,204},
		new int[]{238,206},
		new int[]{239,207},
		new int[]{241},
		new int[]{243},
		new int[]{242},
		new int[]{244},
		new int[]{246},
		new int[]{245},
		new int[]{250},
		new int[]{249},
		new int[]{251},
		new int[]{252},
		new int[]{228},
		new int[]{8800},
		new int[]{198},
		new int[]{230},
		new int[]{338},
		new int[]{339},
		new int[]{8734},
		new int[]{177},
		new int[]{8804},
		new int[]{8805},
		new int[]{167},
		new int[]{182},
		new int[]{223},
		new int[]{8226},
		new int[]{165},
		new int[]{191},
		new int[]{161},
		new int[]{8776},
		new int[]{170},
		new int[]{186},
		new int[]{8211},
		new int[]{8220},
		new int[]{8221},
		new int[]{8216},
		new int[]{8217},
		new int[]{376},
		new int[]{255},
		new int[]{64258},
		new int[]{64257},
		new int[]{164},
		new int[]{8225},
		new int[]{8240},
		new int[]{160},
		new int[]{1041},
		null,
		new int[]{1073},
		new int[]{1074},
		null,
		new int[]{1044},
		new int[]{1076},
		new int[]{1046},
		new int[]{1078},
		new int[]{1079},
		new int[]{1048},
		null,
		new int[]{1080},
		null,
		new int[]{1051},
		null,
		new int[]{1083},
		null,
		new int[]{1059},
		new int[]{1062},
		new int[]{1094},
		null,
		null,
		new int[]{1063},
		null,
		new int[]{1095},
		null,
		new int[]{1049,1081},
		null,
		new int[]{1064},
		new int[]{1065},
		new int[]{1096},
		new int[]{1097},
		new int[]{1067},
		null,
		new int[]{1069},
		null,
		new int[]{1101},
		new int[]{1070},
		new int[]{1102},
		null,
		null,
		new int[]{1071},
		null,
		new int[]{9098},
		new int[]{63386},
		new int[]{63387},
		new int[]{63388},
		new int[]{171},
		new int[]{187},
		new int[]{63377},
		null,
		null,
		null,
		null,
		null,
		new int[]{9786},
		new int[]{9787},
		new int[]{9829},
		new int[]{9830,9670},
		new int[]{9824},
		new int[]{9827},
		new int[]{9794},
		new int[]{9792},
	};
	
	private static final int[][] MAP_SLANTED_HI = new int[][] {
		new int[]{189,8529},
		new int[]{8531},
		new int[]{8532},
		new int[]{188,8528},
		new int[]{190,8530},
		new int[]{8533},
		new int[]{8534},
		new int[]{8535},
		new int[]{8536},
		new int[]{8537},
		new int[]{8538},
		new int[]{8539},
		new int[]{8540},
		new int[]{8541},
		new int[]{8542},
		new int[]{63276},
		new int[]{63277},
		new int[]{63278},
		new int[]{63279},
		new int[]{63264},
		new int[]{63265},
		new int[]{63266},
		new int[]{63267},
		new int[]{63268},
		new int[]{63269},
		new int[]{63270},
		new int[]{63271},
		new int[]{63272},
		new int[]{63273},
		new int[]{63274},
		new int[]{63275},
		new int[]{63312},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{715},
		new int[]{180,714},
		new int[]{168},
		new int[]{710},
		new int[]{711,728},
		new int[]{730},
		new int[]{175,713},
		new int[]{732},
		new int[]{729},
		new int[]{733},
		new int[]{184},
		new int[]{731},
		new int[]{9601},
		new int[]{9615},
		new int[]{9620},
		new int[]{9621},
		new int[]{9472},
		null,
		null,
		null,
		null,
		new int[]{9532},
		new int[]{9496},
		new int[]{9492},
		new int[]{9488},
		new int[]{9484},
		null,
		null,
		null,
		null,
		new int[]{63440},
		new int[]{63442},
		new int[]{63446},
		new int[]{63444},
		new int[]{9565},
		new int[]{9562},
		new int[]{9559},
		new int[]{9556},
		new int[]{9552},
		new int[]{9580},
		new int[]{9553},
		new int[]{9500},
		new int[]{9508},
		new int[]{9516},
		new int[]{9524},
		new int[]{9568},
		new int[]{9571},
		new int[]{9574},
		new int[]{9577},
		new int[]{9474},
		new int[]{9499},
		new int[]{9490},
		new int[]{9493},
		new int[]{9473},
		new int[]{9475},
		new int[]{63447},
		new int[]{63443},
		new int[]{63441},
		new int[]{63445},
		null,
		new int[]{63420},
		new int[]{63421},
		new int[]{9586},
		new int[]{9585},
		new int[]{193},
		new int[]{192},
		new int[]{194},
		new int[]{195},
		new int[]{200},
		new int[]{202},
		new int[]{203},
		new int[]{211},
		new int[]{210},
		new int[]{212},
		new int[]{213},
		new int[]{218},
		new int[]{217},
		new int[]{219},
		new int[]{208},
		new int[]{240},
		new int[]{222},
		new int[]{254},
		new int[]{221},
		new int[]{253},
		new int[]{183},
		new int[]{166},
		new int[]{63234},
		new int[]{63235},
		new int[]{477,601},
		new int[]{9251},
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{63281},
		new int[]{63282},
		new int[]{63283},
		new int[]{63284},
		new int[]{63285},
		new int[]{63286},
		new int[]{63287},
		new int[]{63288,1085},
		new int[]{63289},
		new int[]{63290},
		new int[]{63291},
		new int[]{63292},
		new int[]{63293,1084},
		new int[]{63294},
		new int[]{63295},
		new int[]{63296},
		new int[]{63297},
		new int[]{63298},
		new int[]{63299},
		new int[]{63300,1090},
		new int[]{63301},
		new int[]{63302},
		new int[]{63303},
		new int[]{63304},
		new int[]{63305},
		new int[]{63306},
		new int[]{63232},
		new int[]{63233},
		new int[]{63252},
		new int[]{63250},
		new int[]{63743,63507},
		new int[]{63742,63506},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{63280},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{33},
		new int[]{34},
		new int[]{35},
		new int[]{36},
		new int[]{37},
		new int[]{38},
		new int[]{39},
		new int[]{40},
		new int[]{41},
		new int[]{42},
		new int[]{43},
		new int[]{44},
		new int[]{45,173},
		new int[]{46},
		new int[]{47},
		new int[]{48},
		new int[]{49},
		new int[]{50},
		new int[]{51},
		new int[]{52},
		new int[]{53},
		new int[]{54},
		new int[]{55},
		new int[]{56},
		new int[]{57},
		new int[]{58},
		new int[]{59},
		new int[]{60},
		new int[]{61},
		new int[]{62},
		new int[]{63},
		null,
		new int[]{64},
		new int[]{65},
		new int[]{66},
		new int[]{67},
		new int[]{68},
		new int[]{69},
		new int[]{70},
		new int[]{71},
		new int[]{72},
		new int[]{73},
		new int[]{74},
		new int[]{75},
		new int[]{76},
		new int[]{77},
		new int[]{78},
		new int[]{79},
		new int[]{80},
		new int[]{81},
		new int[]{82},
		new int[]{83},
		new int[]{84},
		new int[]{85},
		new int[]{86},
		new int[]{87},
		new int[]{88},
		new int[]{89},
		new int[]{90},
		new int[]{91},
		new int[]{92},
		new int[]{93},
		new int[]{94},
		new int[]{95},
		new int[]{96},
		new int[]{97},
		new int[]{98},
		new int[]{99},
		new int[]{100},
		new int[]{101},
		new int[]{102},
		new int[]{103},
		new int[]{104},
		new int[]{105},
		new int[]{106},
		new int[]{107},
		new int[]{108},
		new int[]{109},
		new int[]{110},
		new int[]{111},
		new int[]{112},
		new int[]{113},
		new int[]{114},
		new int[]{115},
		new int[]{116},
		new int[]{117},
		new int[]{118},
		new int[]{119},
		new int[]{120},
		new int[]{121},
		new int[]{122},
		new int[]{123},
		new int[]{124},
		new int[]{125},
		new int[]{126},
		new int[]{127,63253},
		null,
		null,
		null,
		null,
		null,
		new int[]{63263},
		new int[]{63260},
		new int[]{63262},
		new int[]{63261},
		new int[]{63347},
		new int[]{63348},
		new int[]{63350},
		new int[]{63351},
		new int[]{63352},
		new int[]{63354},
		new int[]{63355},
		new int[]{63356},
		new int[]{63357},
		new int[]{63360},
		new int[]{63361},
		new int[]{63362},
		new int[]{63365},
		new int[]{63366},
		new int[]{63367},
		new int[]{63368},
		new int[]{63369},
		new int[]{63370},
		new int[]{63315},
		new int[]{63316},
		new int[]{63318},
		new int[]{63319},
		new int[]{63320},
		new int[]{63322},
		new int[]{63323},
		new int[]{63324},
		new int[]{63325},
		new int[]{63328},
		new int[]{63329},
		new int[]{63330},
		new int[]{63333},
		new int[]{63334},
		new int[]{63335},
		new int[]{63336},
		new int[]{63337},
		new int[]{63338},
		new int[]{9581,63448},
		new int[]{9582,63450},
		new int[]{9584,63454},
		new int[]{9583,63452},
		new int[]{63449},
		new int[]{63453},
		new int[]{63455},
		new int[]{63451},
		new int[]{63472},
		new int[]{63429},
		new int[]{63428},
		new int[]{63431},
		new int[]{63430},
		new int[]{63385},
		new int[]{63384},
		new int[]{9604},
		new int[]{9612},
		new int[]{8992},
		new int[]{8993},
	};
	
	private static final int[][] MAP_SMALL_LO = new int[][] {
		new int[]{9216},
		new int[]{9217},
		new int[]{9218},
		new int[]{9219},
		new int[]{9220},
		new int[]{9221},
		new int[]{9222},
		new int[]{9223},
		new int[]{9224},
		new int[]{9225},
		new int[]{9226},
		new int[]{9227},
		new int[]{9228},
		new int[]{9229},
		new int[]{9230},
		new int[]{9231},
		new int[]{9232},
		new int[]{9233},
		new int[]{9234},
		new int[]{9235},
		new int[]{9236},
		new int[]{9237},
		new int[]{9238},
		new int[]{9239},
		new int[]{9240},
		new int[]{9241},
		new int[]{9242},
		new int[]{9243},
		new int[]{9244},
		new int[]{9245},
		new int[]{9246},
		new int[]{9247},
		new int[]{32},
		new int[]{33},
		new int[]{34},
		new int[]{35},
		new int[]{36},
		new int[]{37},
		new int[]{38},
		new int[]{39},
		new int[]{40},
		new int[]{41},
		new int[]{42},
		new int[]{43},
		new int[]{44},
		new int[]{45,173},
		new int[]{46},
		new int[]{47},
		new int[]{48},
		new int[]{49},
		new int[]{50},
		new int[]{51,1047},
		new int[]{52},
		new int[]{53},
		new int[]{54},
		new int[]{55},
		new int[]{56},
		new int[]{57},
		new int[]{58},
		new int[]{59},
		new int[]{60},
		new int[]{61},
		new int[]{62},
		new int[]{63},
		new int[]{64},
		new int[]{65,913,1040},
		new int[]{66,914,1042},
		new int[]{67,1057},
		new int[]{68},
		new int[]{69,917,1045},
		new int[]{70},
		new int[]{71},
		new int[]{72,919,1053},
		new int[]{73,921},
		new int[]{74},
		new int[]{75,922,1050},
		new int[]{76},
		new int[]{77,924,1052},
		new int[]{78,925},
		new int[]{79,927,1054},
		new int[]{80,929,1056},
		new int[]{81},
		new int[]{82},
		new int[]{83},
		new int[]{84,932,1058},
		new int[]{85},
		new int[]{86},
		new int[]{87},
		new int[]{88,935,1061},
		new int[]{89,933},
		new int[]{90,918},
		new int[]{91},
		new int[]{92},
		new int[]{93},
		new int[]{94},
		new int[]{95},
		new int[]{96},
		new int[]{1072},
		null,
		new int[]{1089},
		null,
		new int[]{1077},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{951},
		new int[]{959,1086},
		new int[]{1088},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{967,1093},
		new int[]{1091},
		null,
		new int[]{123},
		new int[]{124},
		new int[]{125},
		new int[]{126},
		null,
		new int[]{8254},
		null,
		new int[]{8212},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{1075},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{127,63253},
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{63376},
		new int[]{8987},
		new int[]{63490},
		new int[]{63432},
		new int[]{63433},
		new int[]{63434},
		new int[]{63378},
		new int[]{63379},
		new int[]{63380},
		new int[]{63381},
		new int[]{8224},
		new int[]{176},
		new int[]{163},
		new int[]{162},
		new int[]{174},
		new int[]{169},
		new int[]{8482},
		new int[]{8230},
		new int[]{8984},
		new int[]{8997},
		new int[]{8679},
		new int[]{8593},
		new int[]{8595},
		new int[]{8592},
		new int[]{8594},
		new int[]{8864},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{915,1043},
		null,
		new int[]{945},
		new int[]{946},
		new int[]{947},
		new int[]{916,8710},
		new int[]{948},
		new int[]{949},
		new int[]{950},
		new int[]{958},
		new int[]{952},
		new int[]{920},
		new int[]{953},
		new int[]{954,1082},
		null,
		new int[]{923},
		new int[]{955},
		null,
		new int[]{181,956},
		new int[]{957},
		new int[]{926},
		null,
		new int[]{928,1055},
		new int[]{960,1087},
		new int[]{8719},
		new int[]{961},
		new int[]{8721},
		new int[]{931},
		new int[]{963},
		new int[]{964},
		new int[]{965},
		new int[]{966,1092},
		new int[]{934,1060},
		new int[]{248,216,8709},
		new int[]{936},
		new int[]{968},
		new int[]{937,8486},
		new int[]{969},
		new int[]{982},
		new int[]{8544},
		new int[]{8548},
		new int[]{8553},
		new int[]{8558},
		new int[]{8557},
		new int[]{8556},
		new int[]{8559},
		new int[]{8626,8629},
		new int[]{8996},
		new int[]{9099},
		new int[]{63382},
		new int[]{63383},
		new int[]{63397},
		new int[]{9788},
		new int[]{9681},
		new int[]{9652},
		new int[]{9662},
		new int[]{9666},
		new int[]{9656},
		new int[]{63416},
		new int[]{63417},
		new int[]{63249},
		null,
		null,
		null,
		null,
		new int[]{63435},
		new int[]{63436},
		new int[]{8677},
		new int[]{8676},
		new int[]{9645},
		new int[]{63419},
		new int[]{9644},
		new int[]{9679},
		new int[]{9675},
		new int[]{9632},
		new int[]{9633},
		new int[]{9712},
		new int[]{9636},
		new int[]{9641},
		new int[]{9673},
		new int[]{63415},
		new int[]{9677},
		new int[]{215},
		new int[]{247},
		new int[]{185},
		new int[]{178,8306},
		new int[]{179,8307},
		new int[]{8308},
		new int[]{8309},
		new int[]{8310},
		new int[]{8311},
		new int[]{8312},
		new int[]{8313},
		new int[]{8304,63327},
		new int[]{63313},
		new int[]{63314},
		new int[]{63317},
		new int[]{63321},
		new int[]{63326},
		new int[]{63331},
		new int[]{63332},
		new int[]{10003},
		new int[]{8730},
		new int[]{8731},
		new int[]{8319},
		new int[]{8321},
		new int[]{8322},
		new int[]{8323},
		new int[]{8324},
		new int[]{8325},
		new int[]{8326},
		new int[]{8327},
		new int[]{8328},
		new int[]{8329},
		new int[]{8320,63359},
		new int[]{8725},
		new int[]{8726},
		new int[]{172},
		new int[]{8747},
		new int[]{402},
		new int[]{63438},
		null,
		null,
		null,
		null,
		new int[]{8865},
		new int[]{8857},
		new int[]{63422},
		new int[]{9000},
		new int[]{8682},
		new int[]{8596},
		new int[]{8597},
		new int[]{63458},
		new int[]{8598},
		new int[]{8599},
		new int[]{8601},
		new int[]{8600},
		new int[]{63457},
		new int[]{63456},
		new int[]{63459},
		new int[]{196},
		new int[]{197},
		new int[]{199},
		new int[]{201},
		new int[]{209},
		new int[]{214},
		new int[]{220},
		new int[]{225},
		new int[]{224},
		new int[]{226},
		new int[]{227},
		new int[]{229},
		new int[]{231},
		new int[]{233},
		new int[]{232},
		new int[]{234},
		new int[]{235},
		new int[]{237,205},
		new int[]{236,204},
		new int[]{238,206},
		new int[]{239,207},
		new int[]{241},
		new int[]{243},
		new int[]{242},
		new int[]{244},
		new int[]{246},
		new int[]{245},
		new int[]{250},
		new int[]{249},
		new int[]{251},
		new int[]{252},
		new int[]{228},
		new int[]{8800},
		new int[]{198},
		new int[]{230},
		new int[]{338},
		new int[]{339},
		new int[]{8734},
		new int[]{177},
		new int[]{8804},
		new int[]{8805},
		new int[]{167},
		new int[]{182},
		new int[]{223},
		new int[]{8226},
		new int[]{165},
		new int[]{191},
		new int[]{161},
		new int[]{8776},
		new int[]{170},
		new int[]{186},
		new int[]{8211},
		new int[]{8220},
		new int[]{8221},
		new int[]{8216},
		new int[]{8217},
		new int[]{376},
		new int[]{255},
		new int[]{64258},
		new int[]{64257},
		new int[]{164},
		new int[]{8225},
		new int[]{8240},
		new int[]{160},
		new int[]{1041},
		null,
		new int[]{1073},
		new int[]{1074},
		null,
		new int[]{1044},
		new int[]{1076},
		new int[]{1046},
		new int[]{1078},
		new int[]{1079},
		new int[]{1048},
		null,
		new int[]{1080},
		null,
		new int[]{1051},
		null,
		new int[]{1083},
		null,
		new int[]{1059},
		new int[]{1062},
		new int[]{1094},
		null,
		null,
		new int[]{1063},
		null,
		new int[]{1095},
		null,
		new int[]{1049,1081},
		null,
		new int[]{1064},
		new int[]{1065},
		new int[]{1096},
		new int[]{1097},
		new int[]{1067},
		null,
		new int[]{1069},
		null,
		new int[]{1101},
		new int[]{1070},
		new int[]{1102},
		null,
		null,
		new int[]{1071},
		null,
		new int[]{9098},
		new int[]{63386},
		new int[]{63387},
		new int[]{63388},
		new int[]{171},
		new int[]{187},
		new int[]{63377},
		null,
		null,
		null,
		null,
		null,
		new int[]{9786},
		new int[]{9787},
		new int[]{9829},
		new int[]{9830,9670},
		new int[]{9824},
		new int[]{9827},
		new int[]{9794},
		new int[]{9792},
	};
	
	private static final int[][] MAP_SMALL_HI = new int[][] {
		new int[]{189,8529},
		new int[]{8531},
		new int[]{8532},
		new int[]{188,8528},
		new int[]{190,8530},
		new int[]{8533},
		new int[]{8534},
		new int[]{8535},
		new int[]{8536},
		new int[]{8537},
		new int[]{8538},
		new int[]{8539},
		new int[]{8540},
		new int[]{8541},
		new int[]{8542},
		new int[]{63276},
		new int[]{63277},
		new int[]{63278},
		new int[]{63279},
		new int[]{63264},
		new int[]{63265},
		new int[]{63266},
		new int[]{63267},
		new int[]{63268},
		new int[]{63269},
		new int[]{63270},
		new int[]{63271},
		new int[]{63272},
		new int[]{63273},
		new int[]{63274},
		new int[]{63275},
		new int[]{63312},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{715},
		new int[]{180,714},
		new int[]{168},
		new int[]{710},
		new int[]{711,728},
		new int[]{730},
		new int[]{175,713},
		new int[]{732},
		new int[]{729},
		new int[]{733},
		new int[]{184},
		new int[]{731},
		new int[]{9601},
		new int[]{9615},
		new int[]{9620},
		new int[]{9621},
		new int[]{9472},
		null,
		null,
		null,
		null,
		new int[]{9532},
		new int[]{9496},
		new int[]{9492},
		new int[]{9488},
		new int[]{9484},
		null,
		null,
		null,
		null,
		new int[]{63440},
		new int[]{63442},
		new int[]{63446},
		new int[]{63444},
		new int[]{9565},
		new int[]{9562},
		new int[]{9559},
		new int[]{9556},
		new int[]{9552},
		new int[]{9580},
		new int[]{9553},
		new int[]{9500},
		new int[]{9508},
		new int[]{9516},
		new int[]{9524},
		new int[]{9568},
		new int[]{9571},
		new int[]{9574},
		new int[]{9577},
		new int[]{9474},
		new int[]{9499},
		new int[]{9490},
		new int[]{9493},
		new int[]{9473},
		new int[]{9475},
		new int[]{63447},
		new int[]{63443},
		new int[]{63441},
		new int[]{63445},
		null,
		new int[]{63420},
		new int[]{63421},
		new int[]{9586},
		new int[]{9585},
		new int[]{193},
		new int[]{192},
		new int[]{194},
		new int[]{195},
		new int[]{200},
		new int[]{202},
		new int[]{203},
		new int[]{211},
		new int[]{210},
		new int[]{212},
		new int[]{213},
		new int[]{218},
		new int[]{217},
		new int[]{219},
		new int[]{208},
		new int[]{240},
		new int[]{222},
		new int[]{254},
		new int[]{221},
		new int[]{253},
		new int[]{183},
		new int[]{166},
		new int[]{63234},
		new int[]{63235},
		new int[]{477,601},
		new int[]{9251},
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{97,63281},
		new int[]{98,63282},
		new int[]{99,63283},
		new int[]{100,63284},
		new int[]{101,63285},
		new int[]{102,63286},
		new int[]{103,63287},
		new int[]{104,63288,1085},
		new int[]{105,63289},
		new int[]{106,63290},
		new int[]{107,63291},
		new int[]{108,63292},
		new int[]{109,63293,1084},
		new int[]{110,63294},
		new int[]{111,63295},
		new int[]{112,63296},
		new int[]{113,63297},
		new int[]{114,63298},
		new int[]{115,63299},
		new int[]{116,63300,1090},
		new int[]{117,63301},
		new int[]{118,63302},
		new int[]{119,63303},
		new int[]{120,63304},
		new int[]{121,63305},
		new int[]{122,63306},
		new int[]{63232},
		new int[]{63233},
		new int[]{63252},
		new int[]{63250},
		new int[]{63743,63507},
		new int[]{63742,63506},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{63280},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{63263},
		new int[]{63260},
		new int[]{63262},
		new int[]{63261},
		new int[]{63347},
		new int[]{63348},
		new int[]{63350},
		new int[]{63351},
		new int[]{63352},
		new int[]{63354},
		new int[]{63355},
		new int[]{63356},
		new int[]{63357},
		new int[]{63360},
		new int[]{63361},
		new int[]{63362},
		new int[]{63365},
		new int[]{63366},
		new int[]{63367},
		new int[]{63368},
		new int[]{63369},
		new int[]{63370},
		new int[]{63315},
		new int[]{63316},
		new int[]{63318},
		new int[]{63319},
		new int[]{63320},
		new int[]{63322},
		new int[]{63323},
		new int[]{63324},
		new int[]{63325},
		new int[]{63328},
		new int[]{63329},
		new int[]{63330},
		new int[]{63333},
		new int[]{63334},
		new int[]{63335},
		new int[]{63336},
		new int[]{63337},
		new int[]{63338},
		new int[]{9581,63448},
		new int[]{9582,63450},
		new int[]{9584,63454},
		new int[]{9583,63452},
		new int[]{63449},
		new int[]{63453},
		new int[]{63455},
		new int[]{63451},
		new int[]{63472},
		new int[]{63429},
		new int[]{63428},
		new int[]{63431},
		new int[]{63430},
		new int[]{63385},
		new int[]{63384},
		new int[]{9604},
		new int[]{9612},
		new int[]{8992},
		new int[]{8993},
	};
	
	private static final int[][] MAP_SCRIPT_LO = new int[][] {
		new int[]{9216},
		new int[]{9217},
		new int[]{9218},
		new int[]{9219},
		new int[]{9220},
		new int[]{9221},
		new int[]{9222},
		new int[]{9223},
		new int[]{9224},
		new int[]{9225},
		new int[]{9226},
		new int[]{9227},
		new int[]{9228},
		new int[]{9229},
		new int[]{9230},
		new int[]{9231},
		new int[]{9232},
		new int[]{9233},
		new int[]{9234},
		new int[]{9235},
		new int[]{9236},
		new int[]{9237},
		new int[]{9238},
		new int[]{9239},
		new int[]{9240},
		new int[]{9241},
		new int[]{9242},
		new int[]{9243},
		new int[]{9244},
		new int[]{9245},
		new int[]{9246},
		new int[]{9247},
		new int[]{32},
		new int[]{33},
		new int[]{34},
		new int[]{35},
		new int[]{36},
		new int[]{37},
		null,
		new int[]{39},
		new int[]{40},
		new int[]{41},
		new int[]{42},
		new int[]{43},
		new int[]{44},
		new int[]{45,173},
		new int[]{46},
		new int[]{47},
		new int[]{48},
		new int[]{49},
		new int[]{50},
		new int[]{51,1047},
		new int[]{52},
		new int[]{53},
		new int[]{54},
		new int[]{55},
		new int[]{56},
		new int[]{57},
		new int[]{58},
		new int[]{59},
		new int[]{60},
		new int[]{61},
		new int[]{62},
		new int[]{63},
		new int[]{64},
		new int[]{65,913,1040},
		new int[]{66,914,1042},
		new int[]{67,1057},
		new int[]{68},
		new int[]{917,1045},
		new int[]{70},
		null,
		new int[]{72,919,1053},
		new int[]{73,921},
		null,
		new int[]{75,922,1050},
		new int[]{76},
		new int[]{77,924,1052},
		new int[]{78,925},
		new int[]{79,927,1054},
		new int[]{80,929,1056},
		new int[]{81},
		new int[]{82},
		null,
		new int[]{84,932,1058},
		new int[]{85},
		new int[]{86},
		new int[]{87},
		new int[]{88,935,1061},
		new int[]{933},
		new int[]{90,918},
		new int[]{91},
		new int[]{92},
		new int[]{93},
		new int[]{94},
		new int[]{95},
		new int[]{96},
		new int[]{1072},
		null,
		new int[]{1089},
		null,
		new int[]{1077},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{951},
		new int[]{959,1086},
		new int[]{1088},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{967,1093},
		new int[]{1091},
		null,
		new int[]{123},
		new int[]{124},
		new int[]{125},
		new int[]{126},
		null,
		new int[]{8254},
		null,
		new int[]{8212},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{1075},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{127,63253},
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{63376},
		new int[]{8987},
		new int[]{63490},
		new int[]{63432},
		new int[]{63433},
		new int[]{63434},
		new int[]{63378},
		new int[]{63379},
		new int[]{63380},
		new int[]{63381},
		new int[]{8224},
		new int[]{176},
		new int[]{163},
		new int[]{162},
		new int[]{174},
		new int[]{169},
		new int[]{8482},
		new int[]{8230},
		new int[]{8984},
		new int[]{8997},
		new int[]{8679},
		new int[]{8593},
		new int[]{8595},
		new int[]{8592},
		new int[]{8594},
		new int[]{8864},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{915,1043},
		null,
		new int[]{945},
		new int[]{946},
		new int[]{947},
		new int[]{916,8710},
		new int[]{948},
		new int[]{949},
		new int[]{950},
		new int[]{958},
		new int[]{952},
		new int[]{920},
		new int[]{953},
		new int[]{954,1082},
		null,
		new int[]{923},
		new int[]{955},
		null,
		new int[]{181,956},
		new int[]{957},
		new int[]{926},
		null,
		new int[]{928,1055},
		new int[]{960,1087},
		new int[]{8719},
		new int[]{961},
		new int[]{8721},
		new int[]{931},
		new int[]{963},
		new int[]{964},
		new int[]{965},
		new int[]{966,1092},
		new int[]{934,1060},
		new int[]{248,216,8709},
		new int[]{936},
		new int[]{968},
		new int[]{937,8486},
		new int[]{969},
		new int[]{982},
		new int[]{8544},
		new int[]{8548},
		new int[]{8553},
		new int[]{8558},
		new int[]{8557},
		new int[]{8556},
		new int[]{8559},
		new int[]{8626,8629},
		new int[]{8996},
		new int[]{9099},
		new int[]{63382},
		new int[]{63383},
		new int[]{63397},
		new int[]{9788},
		new int[]{9681},
		new int[]{9652},
		new int[]{9662},
		new int[]{9666},
		new int[]{9656},
		new int[]{63416},
		new int[]{63417},
		new int[]{63249},
		null,
		null,
		null,
		null,
		new int[]{63435},
		new int[]{63436},
		new int[]{8677},
		new int[]{8676},
		new int[]{9645},
		new int[]{63419},
		new int[]{9644},
		new int[]{9679},
		new int[]{9675},
		new int[]{9632},
		new int[]{9633},
		new int[]{9712},
		new int[]{9636},
		new int[]{9641},
		new int[]{9673},
		new int[]{63415},
		new int[]{9677},
		new int[]{215},
		new int[]{247},
		new int[]{185},
		new int[]{178,8306},
		new int[]{179,8307},
		new int[]{8308},
		new int[]{8309},
		new int[]{8310},
		new int[]{8311},
		new int[]{8312},
		new int[]{8313},
		new int[]{8304,63327},
		new int[]{63313},
		new int[]{63314},
		new int[]{63317},
		new int[]{63321},
		new int[]{63326},
		new int[]{63331},
		new int[]{63332},
		new int[]{10003},
		new int[]{8730},
		new int[]{8731},
		new int[]{8319},
		new int[]{8321},
		new int[]{8322},
		new int[]{8323},
		new int[]{8324},
		new int[]{8325},
		new int[]{8326},
		new int[]{8327},
		new int[]{8328},
		new int[]{8329},
		new int[]{8320,63359},
		new int[]{8725},
		new int[]{8726},
		new int[]{172},
		new int[]{8747},
		new int[]{402},
		new int[]{63438},
		null,
		null,
		null,
		null,
		new int[]{8865},
		new int[]{8857},
		new int[]{63422},
		new int[]{9000},
		new int[]{8682},
		new int[]{8596},
		new int[]{8597},
		new int[]{63458},
		new int[]{8598},
		new int[]{8599},
		new int[]{8601},
		new int[]{8600},
		new int[]{63457},
		new int[]{63456},
		new int[]{63459},
		new int[]{196},
		new int[]{197},
		new int[]{199},
		new int[]{201},
		new int[]{209},
		new int[]{214},
		new int[]{220},
		new int[]{225},
		new int[]{224},
		new int[]{226},
		new int[]{227},
		new int[]{229},
		new int[]{231},
		new int[]{233},
		new int[]{232},
		new int[]{234},
		new int[]{235},
		new int[]{237,205},
		new int[]{236,204},
		new int[]{238,206},
		new int[]{239,207},
		new int[]{241},
		new int[]{243},
		new int[]{242},
		new int[]{244},
		new int[]{246},
		new int[]{245},
		new int[]{250},
		new int[]{249},
		new int[]{251},
		new int[]{252},
		new int[]{228},
		new int[]{8800},
		new int[]{198},
		new int[]{230},
		new int[]{338},
		new int[]{339},
		new int[]{8734},
		new int[]{177},
		new int[]{8804},
		new int[]{8805},
		new int[]{167},
		new int[]{182},
		new int[]{223},
		new int[]{8226},
		new int[]{165},
		new int[]{191},
		new int[]{161},
		new int[]{8776},
		new int[]{170},
		new int[]{186},
		new int[]{8211},
		new int[]{8220},
		new int[]{8221},
		new int[]{8216},
		new int[]{8217},
		new int[]{376},
		new int[]{255},
		new int[]{64258},
		new int[]{64257},
		new int[]{164},
		new int[]{8225},
		new int[]{8240},
		new int[]{160},
		new int[]{1041},
		null,
		new int[]{1073},
		new int[]{1074},
		null,
		new int[]{1044},
		new int[]{1076},
		new int[]{1046},
		new int[]{1078},
		new int[]{1079},
		new int[]{1048},
		null,
		new int[]{1080},
		null,
		new int[]{1051},
		null,
		new int[]{1083},
		null,
		new int[]{1059},
		new int[]{1062},
		new int[]{1094},
		null,
		null,
		new int[]{1063},
		null,
		new int[]{1095},
		null,
		new int[]{1049,1081},
		null,
		new int[]{1064},
		new int[]{1065},
		new int[]{1096},
		new int[]{1097},
		new int[]{1067},
		null,
		new int[]{1069},
		null,
		new int[]{1101},
		new int[]{1070},
		new int[]{1102},
		null,
		null,
		new int[]{1071},
		null,
		new int[]{9098},
		new int[]{63386},
		new int[]{63387},
		new int[]{63388},
		new int[]{171},
		new int[]{187},
		new int[]{63377},
		null,
		null,
		null,
		null,
		null,
		new int[]{9786},
		new int[]{9787},
		new int[]{9829},
		new int[]{9830,9670},
		new int[]{9824},
		new int[]{9827},
		new int[]{9794},
		new int[]{9792},
	};
	
	private static final int[][] MAP_SCRIPT_HI = new int[][] {
		new int[]{189,8529},
		new int[]{8531},
		new int[]{8532},
		new int[]{188,8528},
		new int[]{190,8530},
		new int[]{8533},
		new int[]{8534},
		new int[]{8535},
		new int[]{8536},
		new int[]{8537},
		new int[]{8538},
		new int[]{8539},
		new int[]{8540},
		new int[]{8541},
		new int[]{8542},
		new int[]{63276},
		new int[]{63277},
		new int[]{63278},
		new int[]{63279},
		new int[]{63264},
		new int[]{63265},
		new int[]{63266},
		new int[]{63267},
		new int[]{63268},
		new int[]{63269},
		new int[]{63270},
		new int[]{63271},
		new int[]{63272},
		new int[]{63273},
		new int[]{63274},
		new int[]{63275},
		new int[]{63312},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{715},
		new int[]{180,714},
		new int[]{168},
		new int[]{710},
		new int[]{711,728},
		new int[]{730},
		new int[]{175,713},
		new int[]{732},
		new int[]{729},
		new int[]{733},
		new int[]{184},
		new int[]{731},
		new int[]{9601},
		new int[]{9615},
		new int[]{9620},
		new int[]{9621},
		new int[]{9472},
		null,
		null,
		null,
		null,
		new int[]{9532},
		new int[]{9496},
		new int[]{9492},
		new int[]{9488},
		new int[]{9484},
		null,
		null,
		null,
		null,
		new int[]{63440},
		new int[]{63442},
		new int[]{63446},
		new int[]{63444},
		new int[]{9565},
		new int[]{9562},
		new int[]{9559},
		new int[]{9556},
		new int[]{9552},
		new int[]{9580},
		new int[]{9553},
		new int[]{9500},
		new int[]{9508},
		new int[]{9516},
		new int[]{9524},
		new int[]{9568},
		new int[]{9571},
		new int[]{9574},
		new int[]{9577},
		new int[]{9474},
		new int[]{9499},
		new int[]{9490},
		new int[]{9493},
		new int[]{9473},
		new int[]{9475},
		new int[]{63447},
		new int[]{63443},
		new int[]{63441},
		new int[]{63445},
		null,
		new int[]{63420},
		new int[]{63421},
		new int[]{9586},
		new int[]{9585},
		new int[]{193},
		new int[]{192},
		new int[]{194},
		new int[]{195},
		new int[]{200},
		new int[]{202},
		new int[]{203},
		new int[]{211},
		new int[]{210},
		new int[]{212},
		new int[]{213},
		new int[]{218},
		new int[]{217},
		new int[]{219},
		new int[]{208},
		new int[]{240},
		new int[]{222},
		new int[]{254},
		new int[]{221},
		new int[]{253},
		new int[]{183},
		new int[]{166},
		new int[]{63234},
		new int[]{63235},
		new int[]{477,601},
		new int[]{9251},
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{63281},
		new int[]{63282},
		new int[]{63283},
		new int[]{63284},
		new int[]{63285},
		new int[]{63286},
		new int[]{63287},
		new int[]{63288,1085},
		new int[]{63289},
		new int[]{63290},
		new int[]{63291},
		new int[]{63292},
		new int[]{63293,1084},
		new int[]{63294},
		new int[]{63295},
		new int[]{63296},
		new int[]{63297},
		new int[]{63298},
		new int[]{63299},
		new int[]{63300,1090},
		new int[]{63301},
		new int[]{63302},
		new int[]{63303},
		new int[]{63304},
		new int[]{63305},
		new int[]{63306},
		new int[]{63232},
		new int[]{63233},
		new int[]{63252},
		new int[]{63250},
		new int[]{63743,63507},
		new int[]{63742,63506},
		new int[]{69},
		new int[]{71},
		new int[]{74},
		new int[]{89},
		new int[]{97},
		new int[]{98},
		new int[]{99},
		new int[]{100},
		new int[]{101},
		new int[]{102},
		new int[]{103},
		new int[]{104},
		new int[]{105},
		new int[]{106},
		new int[]{107},
		new int[]{108},
		new int[]{109},
		new int[]{110},
		new int[]{111},
		new int[]{112},
		new int[]{113},
		new int[]{114},
		new int[]{115},
		new int[]{116},
		new int[]{117},
		new int[]{118},
		new int[]{119},
		new int[]{120},
		new int[]{121},
		new int[]{122},
		new int[]{83},
		new int[]{38,63280},
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		null,
		new int[]{63263},
		new int[]{63260},
		new int[]{63262},
		new int[]{63261},
		new int[]{63347},
		new int[]{63348},
		new int[]{63350},
		new int[]{63351},
		new int[]{63352},
		new int[]{63354},
		new int[]{63355},
		new int[]{63356},
		new int[]{63357},
		new int[]{63360},
		new int[]{63361},
		new int[]{63362},
		new int[]{63365},
		new int[]{63366},
		new int[]{63367},
		new int[]{63368},
		new int[]{63369},
		new int[]{63370},
		new int[]{63315},
		new int[]{63316},
		new int[]{63318},
		new int[]{63319},
		new int[]{63320},
		new int[]{63322},
		new int[]{63323},
		new int[]{63324},
		new int[]{63325},
		new int[]{63328},
		new int[]{63329},
		new int[]{63330},
		new int[]{63333},
		new int[]{63334},
		new int[]{63335},
		new int[]{63336},
		new int[]{63337},
		new int[]{63338},
		new int[]{9581,63448},
		new int[]{9582,63450},
		new int[]{9584,63454},
		new int[]{9583,63452},
		new int[]{63449},
		new int[]{63453},
		new int[]{63455},
		new int[]{63451},
		new int[]{63472},
		new int[]{63429},
		new int[]{63428},
		new int[]{63431},
		new int[]{63430},
		new int[]{63385},
		new int[]{63384},
		new int[]{9604},
		new int[]{9612},
		new int[]{8992},
		new int[]{8993},
	};
}
