/* foundry-menu-proxy.h
 *
 * Copyright 2025 Christian Hergert <chergert@redhat.com>
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#pragma once

#include <gio/gio.h>

#include "foundry-version-macros.h"

G_BEGIN_DECLS

#define FOUNDRY_TYPE_MENU_PROXY (foundry_menu_proxy_get_type())

FOUNDRY_AVAILABLE_IN_ALL
G_DECLARE_FINAL_TYPE (FoundryMenuProxy, foundry_menu_proxy, FOUNDRY, MENU_PROXY, GMenuModel)

FOUNDRY_AVAILABLE_IN_ALL
FoundryMenuProxy *foundry_menu_proxy_new         (const char       *menu_id);
FOUNDRY_AVAILABLE_IN_ALL
const char       *foundry_menu_proxy_get_menu_id (FoundryMenuProxy *self);
FOUNDRY_AVAILABLE_IN_ALL
void              foundry_menu_proxy_set_menu_id (FoundryMenuProxy *self,
                                                  const char       *menu_id);

G_END_DECLS
