## Copyright (C) 1995-2007 R Core Team
## Copyright (C) 2019, 2023, 2024 Andrew Janke
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; If not, see <http://www.gnu.org/licenses/>.

# This is based on the UKDriverDeaths dataset from R’s datasets package

classdef UKDriverDeaths < tblish.internal.dataset

  methods

    function this = UKDriverDeaths
      this.name = "UKDriverDeaths";
      this.summary = "Road Casualties in Great Britain 1969-84";
    endfunction

    function out = load (this)
      month = [datetime(1969, 1, 1):calmonths(1):datetime(1984, 12, 1)]';
      deaths = [1687, 1508, 1507, 1385, 1632, 1511, 1559, 1630, 1579, ...
        1653, 2152, 2148, 1752, 1765, 1717, 1558, 1575, 1520, 1805, 1800, ...
        1719, 2008, 2242, 2478, 2030, 1655, 1693, 1623, 1805, 1746, 1795, ...
        1926, 1619, 1992, 2233, 2192, 2080, 1768, 1835, 1569, 1976, 1853, ...
        1965, 1689, 1778, 1976, 2397, 2654, 2097, 1963, 1677, 1941, 2003, ...
        1813, 2012, 1912, 2084, 2080, 2118, 2150, 1608, 1503, 1548, 1382, ...
        1731, 1798, 1779, 1887, 2004, 2077, 2092, 2051, 1577, 1356, 1652, ...
        1382, 1519, 1421, 1442, 1543, 1656, 1561, 1905, 2199, 1473, 1655, ...
        1407, 1395, 1530, 1309, 1526, 1327, 1627, 1748, 1958, 2274, 1648, ...
        1401, 1411, 1403, 1394, 1520, 1528, 1643, 1515, 1685, 2000, 2215, ...
        1956, 1462, 1563, 1459, 1446, 1622, 1657, 1638, 1643, 1683, 2050, ...
        2262, 1813, 1445, 1762, 1461, 1556, 1431, 1427, 1554, 1645, 1653, ...
        2016, 2207, 1665, 1361, 1506, 1360, 1453, 1522, 1460, 1552, 1548, ...
        1827, 1737, 1941, 1474, 1458, 1542, 1404, 1522, 1385, 1641, 1510, ...
        1681, 1938, 1868, 1726, 1456, 1445, 1456, 1365, 1487, 1558, 1488, ...
        1684, 1594, 1850, 1998, 2079, 1494, 1057, 1218, 1168, 1236, 1076, ...
        1174, 1139, 1427, 1487, 1483, 1513, 1357, 1165, 1282, 1110, 1297, ...
        1185, 1222, 1284, 1444, 1575, 1737, 1763]';
      UKDriverDeaths = table (month, deaths);
      x = reshape ([107, 97, 102, 87, 119, 106, 110, 106, 107, ...
        134, 147, 180, 125, 134, 110, 102, 103, 111, 120, 129, 122, 183, 169, ...
        190, 134, 108, 104, 117, 157, 148, 130, 140, 136, 140, 187, 150, 159, ...
        143, 114, 127, 159, 156, 138, 120, 117, 170, 168, 198, 144, 146, 109, ...
        131, 151, 140, 153, 140, 161, 168, 152, 136, 113, 100, 103, 103, 121, ...
        134, 133, 129, 144, 154, 156, 163, 122, 92, 117, 95, 96, 108, 108, ...
        106, 140, 114, 158, 161, 102, 127, 125, 101, 97, 112, 112, 113, 108, ...
        128, 154, 162, 112, 79, 82, 127, 108, 110, 123, 103, 97, 140, 165, ...
        183, 148, 111, 116, 115, 100, 106, 134, 125, 117, 122, 153, 178, 114, ...
        94, 128, 119, 111, 110, 114, 118, 115, 132, 153, 171, 115, 95, 92, ...
        100, 95, 114, 102, 104, 132, 136, 117, 137, 111, 106, 98, 84, 94, 105, ...
        123, 109, 130, 153, 134, 99, 115, 104, 131, 108, 103, 115, 122, 122, ...
        125, 137, 138, 152, 120, 95, 100, 89, 82, 89, 60, 84, 113, 126, 122, ...
        118, 92, 86, 81, 84, 87, 90, 79, 96, 122, 120, 137, 154, 1687, 1508, ...
        1507, 1385, 1632, 1511, 1559, 1630, 1579, 1653, 2152, 2148, 1752, ...
        1765, 1717, 1558, 1575, 1520, 1805, 1800, 1719, 2008, 2242, 2478, ...
        2030, 1655, 1693, 1623, 1805, 1746, 1795, 1926, 1619, 1992, 2233, ...
        2192, 2080, 1768, 1835, 1569, 1976, 1853, 1965, 1689, 1778, 1976, ...
        2397, 2654, 2097, 1963, 1677, 1941, 2003, 1813, 2012, 1912, 2084, ...
        2080, 2118, 2150, 1608, 1503, 1548, 1382, 1731, 1798, 1779, 1887, ...
        2004, 2077, 2092, 2051, 1577, 1356, 1652, 1382, 1519, 1421, 1442, ...
        1543, 1656, 1561, 1905, 2199, 1473, 1655, 1407, 1395, 1530, 1309, ...
        1526, 1327, 1627, 1748, 1958, 2274, 1648, 1401, 1411, 1403, 1394, ...
        1520, 1528, 1643, 1515, 1685, 2000, 2215, 1956, 1462, 1563, 1459, ...
        1446, 1622, 1657, 1638, 1643, 1683, 2050, 2262, 1813, 1445, 1762, ...
        1461, 1556, 1431, 1427, 1554, 1645, 1653, 2016, 2207, 1665, 1361, ...
        1506, 1360, 1453, 1522, 1460, 1552, 1548, 1827, 1737, 1941, 1474, ...
        1458, 1542, 1404, 1522, 1385, 1641, 1510, 1681, 1938, 1868, 1726, ...
        1456, 1445, 1456, 1365, 1487, 1558, 1488, 1684, 1594, 1850, 1998, ...
        2079, 1494, 1057, 1218, 1168, 1236, 1076, 1174, 1139, 1427, 1487, ...
        1483, 1513, 1357, 1165, 1282, 1110, 1297, 1185, 1222, 1284, 1444, ...
        1575, 1737, 1763, 867, 825, 806, 814, 991, 945, 1004, 1091, 958, 850, ...
        1109, 1113, 925, 903, 1006, 892, 990, 866, 1095, 1204, 1029, 1147, ...
        1171, 1299, 944, 874, 840, 893, 1007, 973, 1097, 1194, 988, 1077, ...
        1045, 1115, 1005, 857, 879, 887, 1075, 1121, 1190, 1058, 939, 1074, ...
        1089, 1208, 903, 916, 787, 1114, 1014, 1022, 1114, 1132, 1111, 1008, ...
        916, 992, 731, 665, 724, 744, 910, 883, 900, 1057, 1076, 919, 920, ...
        953, 664, 607, 777, 633, 791, 790, 803, 884, 769, 732, 859, 994, 704, ...
        684, 671, 643, 771, 644, 828, 748, 767, 825, 810, 986, 714, 567, 616, ...
        678, 742, 840, 888, 852, 774, 831, 889, 1046, 889, 626, 808, 746, 754, ...
        865, 980, 959, 856, 798, 942, 1010, 796, 643, 794, 750, 809, 716, 851, ...
        931, 834, 762, 880, 1077, 748, 593, 720, 646, 765, 820, 807, 885, 803, ...
        860, 825, 911, 704, 691, 688, 714, 814, 736, 876, 829, 818, 942, 782, ...
        823, 595, 673, 660, 676, 755, 815, 867, 933, 798, 950, 825, 911, 619, ...
        426, 475, 556, 559, 483, 587, 615, 618, 662, 519, 585, 483, 434, 513, ...
        548, 586, 522, 601, 644, 643, 641, 711, 721, 269, 265, 319, 407, 454, ...
        427, 522, 536, 405, 437, 434, 437, 316, 311, 351, 362, 486, 429, 551, ...
        646, 456, 475, 456, 468, 356, 271, 354, 427, 465, 440, 539, 646, 457, ...
        446, 402, 441, 359, 334, 312, 427, 434, 486, 569, 523, 418, 452, 462, ...
        497, 354, 347, 276, 472, 487, 505, 619, 640, 559, 453, 418, 419, 262, ...
        299, 303, 401, 413, 426, 516, 600, 459, 443, 412, 400, 278, 302, 381, ...
        279, 442, 409, 416, 511, 393, 345, 391, 470, 266, 312, 300, 373, 412, ...
        322, 458, 427, 346, 421, 344, 370, 291, 224, 266, 338, 298, 386, 479, ...
        473, 332, 391, 370, 431, 366, 250, 355, 304, 379, 440, 500, 511, 384, ...
        366, 432, 390, 306, 232, 342, 329, 394, 355, 385, 463, 453, 373, 401, ...
        466, 306, 263, 323, 310, 424, 403, 406, 466, 381, 369, 378, 392, 284, ...
        316, 321, 358, 378, 382, 433, 506, 428, 479, 370, 349, 238, 285, 324, ...
        346, 410, 411, 496, 534, 396, 470, 385, 411, 281, 300, 318, 391, 398, ...
        337, 477, 422, 495, 471, 368, 345, 296, 319, 349, 375, 441, 465, 472, ...
        521, 429, 408, 490, 491, 9059, 7685, 9963, 10955, 11823, 12391, 13460, ...
        14055, 12106, 11372, 9834, 9267, 9130, 8933, 11000, 10733, 12912, ...
        12926, 13990, 14926, 12900, 12034, 10643, 10742, 10266, 10281, 11527, ...
        12281, 13587, 13049, 16055, 15220, 13824, 12729, 11467, 11351, 10803, ...
        10548, 12368, 13311, 13885, 14088, 16932, 16164, 14883, 13532, 12220, ...
        12025, 11692, 11081, 13745, 14382, 14391, 15597, 16834, 17282, 15779, ...
        13946, 12701, 10431, 11616, 10808, 12421, 13605, 14455, 15019, 15662, ...
        16745, 14717, 13756, 12531, 12568, 11249, 11096, 12637, 13018, 15005, ...
        15235, 15552, 16905, 14776, 14104, 12854, 12956, 12177, 11918, 13517, ...
        14417, 15911, 15589, 16543, 17925, 15406, 14601, 13107, 12268, 11972, ...
        12028, 14033, 14244, 15287, 16954, 17361, 17694, 16222, 14969, 13624, ...
        13842, 12387, 11608, 15021, 14834, 16565, 16882, 18012, 18855, 17243, ...
        16045, 14745, 13726, 11196, 12105, 14723, 15582, 16863, 16758, 17434, ...
        18359, 17189, 16909, 15380, 15161, 14027, 14478, 16155, 16585, 18117, ...
        17552, 18299, 19361, 17924, 17872, 16058, 15746, 15226, 14932, 16846, ...
        16854, 18146, 17559, 18655, 19453, 17923, 17915, 16496, 13544, 13601, ...
        15667, 17358, 18112, 18581, 18759, 20668, 21040, 18993, 18668, 16768, ...
        16551, 16231, 15511, 18308, 17793, 19205, 19162, 20997, 20705, 18759, ...
        19240, 17504, 16591, 16224, 16670, 18539, 19759, 19584, 19976, 21486, ...
        21626, 20195, 19928, 18564, 18149, 0.102971811805368, ...
        0.102362995884646, 0.102062490635914, 0.100873300511862, ...
        0.101019672891934, 0.100581191702870, 0.103773981457839, ...
        0.104076403554621, 0.103773981457839, 0.103026401330572, ...
        0.102730112155946, 0.101997191539847, 0.101274563494893, ...
        0.100703975639720, 0.100139606658898, 0.0986211043713023, ...
        0.0983492854059603, 0.0980801772105387, 0.0972792082183714, ...
        0.0974106238350488, 0.0974252365245483, 0.0963806330037465, ...
        0.0957389559626943, 0.0951063062359475, 0.0967359671470176, ...
        0.0961092224873678, 0.095367254851379, 0.0947095915871269, ...
        0.0941176202174608, 0.0935321548190638, 0.0929540494377308, ...
        0.0928397862431927, 0.0927247362539862, 0.0922696509793897, ...
        0.0917066851479679, 0.0912620719433678, 0.090711603254936, ...
        0.090276328119195, 0.0899519176272147, 0.0890996386561615, ...
        0.0886791925043499, 0.0881592888670634, 0.0889020568552906, ...
        0.0881813314444876, 0.0889402929599117, 0.0877266104275971, ...
        0.087428846437772, 0.0870354301608856, 0.0864499193294655, ...
        0.0858726409121568, 0.0853982218357345, 0.083821981233605, ...
        0.0845907801489325, 0.0841369037739444, 0.0837784051341314, ...
        0.0835107427259604, 0.0828063938633846, 0.0811788933269884, ...
        0.0828536069623417, 0.0941901186933595, 0.0923998429510411, ...
        0.108161478199019, 0.10721168869023, 0.114042966782082, ...
        0.112454115810183, 0.111316253290611, 0.110301252212420, ...
        0.108197177376865, 0.107027443082328, 0.104946980916917, ...
        0.119357749193208, 0.117621904277373, 0.133027420877451, ...
        0.130845243689729, 0.128318477474772, 0.123547448292297, ...
        0.118586811514179, 0.116337480161004, 0.115161475581960, ...
        0.114501197216867, 0.113522979499817, 0.111930179432996, ...
        0.110610528503361, 0.115274389146640, 0.113793485966034, ...
        0.112349582098189, 0.111753469387189, 0.109642522576533, ...
        0.108440895105590, 0.107884938936114, 0.109084769191454, ...
        0.107571450111271, 0.106164022368002, 0.106299999323319, ...
        0.104825313000088, 0.103451745711815, 0.101449920129493, ...
        0.100402316427863, 0.098862033680192, 0.102496154313521, ...
        0.103027431599736, 0.102178908220655, 0.0998366428726473, ...
        0.0926366895833353, 0.0918149629077569, 0.090724303768407, ...
        0.0900212072768793, 0.0893307058230937, 0.0884427348717763, ...
        0.0883525692744791, 0.0867573619308237, 0.0849952420449752, ...
        0.0845679437213488, 0.0844318988774436, 0.0843508831482932, ...
        0.0836009830491076, 0.0834172630524962, 0.0827451397987249, ...
        0.0852352669035281, 0.0847703028296526, 0.0844589214084587, ...
        0.085352119244763, 0.0875592125175749, 0.0903829170614837, ...
        0.0907832937355188, 0.108742780219868, 0.114142227335262, ...
        0.112992933231466, 0.111320706029796, 0.109126229280665, ...
        0.107698459343112, 0.107601574334496, 0.103775019202843, ...
        0.107114170431059, 0.107374774370757, 0.111695372689559, ...
        0.110638184592354, 0.111855211329895, 0.109742342683337, ...
        0.108193931510232, 0.106255362697951, 0.104193034427699, ...
        0.101933972880902, 0.102793824574291, 0.10476034144929, ...
        0.104002535534347, 0.116655515402424, 0.115161475581960, ...
        0.112989543494316, 0.113860643932406, 0.119118081064489, ...
        0.124489986005886, 0.123222945411622, 0.120677932128660, ...
        0.121048982651421, 0.116968571491487, 0.112750259392875, ...
        0.108079306704711, 0.108838515984019, 0.111291766408542, ...
        0.111304009176187, 0.115454357532553, 0.114768296055692, ...
        0.117207430931122, 0.119076397031248, 0.117965862171995, ...
        0.117449127100423, 0.116988457838933, 0.112610535717810, ...
        0.113657015681422, 0.113144445252379, 0.118495534815352, ...
        0.117969401200945, 0.1176866141183, 0.120059238961094, ...
        0.119437745680998, 0.118881271786551, 0.118462360710195, ...
        0.118016598400236, 0.117706622543368, 0.117776089941536, ...
        0.114796991716514, 0.115735252770850, 0.115356263024722, ...
        0.114815360704668, 0.114777477886645, 0.114935980147534, ...
        0.114796991716514, 0.114093156728444, 0.116465521799171, ...
        0.116026113132354, 0.116066729379379, 12, 6, 12, 8, 10, 13, 11, 6, 10, ...
        16, 13, 14, 14, 6, 8, 11, 7, 13, 13, 11, 11, 14, 16, 14, 17, 16, 15, ...
        13, 13, 15, 12, 6, 9, 13, 14, 15, 14, 3, 12, 13, 12, 8, 8, 15, 8, 5, ...
        17, 14, 13, 5, 8, 5, 12, 11, 13, 15, 11, 11, 10, 13, 8, 6, 8, 14, 12, ...
        14, 13, 9, 4, 13, 6, 15, 12, 16, 7, 12, 10, 9, 9, 6, 7, 13, 14, 13, ...
        14, 11, 11, 10, 4, 8, 9, 10, 10, 5, 13, 12, 10, 9, 7, 5, 10, 5, 6, 8, ...
        6, 12, 15, 7, 14, 4, 10, 8, 7, 11, 3, 5, 11, 10, 10, 7, 10, 11, 9, 7, ...
        8, 13, 8, 5, 8, 7, 12, 10, 7, 4, 10, 4, 8, 8, 7, 10, 8, 14, 8, 9, 8, ...
        6, 7, 6, 5, 4, 5, 10, 7, 10, 12, 7, 4, 5, 6, 4, 4, 8, 8, 3, 7, 12, 2, ...
        7, 8, 3, 2, 6, 3, 7, 6, 8, 8, 4, 3, 5, 5, 3, 4, 3, 6, 6, 7, 5, 7, 7, ...
        4, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, ...
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, ...
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, ...
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, ...
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, ...
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, ...
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, ...
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, ...
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1], [192 8]);
      Seatbelts = array2table (x, "VariableNames", {"DriversKilled", "drivers", ...
        "front", "rear", "kms", "PetrolPrice", "VanKilled", "law"});
      Seatbelts = [table(month) Seatbelts];
      out.UKDriverDeaths = UKDriverDeaths;
      out.Seatbelts = Seatbelts;
    endfunction

  endmethods

endclassdef
