# 💡Specialized Configs

It should also be noted that Phoenix contains specialized configurations for **Apple Maps**, **Discord**, **Element**, **Google Maps**, **Twitter**, and **YouTube**. These configs are designed to be used in their own, separate Firefox profile, and provide means to safely and easily use these services, like you would any other app on your device.

> [!IMPORTANT] 
> ⚠️ **Discord**, **Google Maps**, **Twitter**, and **YouTube** are explicitly **not** recommended for use, due to their privacy-invasive nature. These configs are simply meant to provide **harm reduction** for users who need to use these services for whatever reason, **but it is still best to avoid them entirely if possible.**

The installation of these configs is the same as `Extended`, with the only exception being the location of the `user.js` file. **You can find the location of these user.js files at the following locations:**

**<details><summary>Apple Maps</summary>**

**<details><summary>GNU/Linux</summary>**

**Standard**:

```sh
/etc/firefox/phoenix/userjs/apple-maps/user.js
```

**Flatpak**:

```sh
/var/lib/flatpak/app/org.mozilla.firefox/current/active/files/etc/firefox/phoenix/userjs/apple-maps/user.js
```

</details>

**<details><summary>macOS</summary>**

**Apple Silicon**:

```sh
/opt/homebrew/opt/phoenix-osx/userjs/apple-maps/user.js
```

**Intel**:

```sh
/usr/local/opt/phoenix-osx/userjs/apple-maps/user.js
```

</details>

</details>

**<details><summary>Apple Maps (Firefox-UI-Fix)</summary>**

**<details><summary>GNU/Linux</summary>**

**Standard**:

```sh
/etc/firefox/phoenix/userjs/ui-fix/apple-maps/user.js
```

**Flatpak**:

```sh
/var/lib/flatpak/app/org.mozilla.firefox/current/active/files/etc/firefox/phoenix/userjs/ui-fix/apple-maps/user.js
```

</details>

**<details><summary>macOS</summary>**

**Apple Silicon**:

```sh
/opt/homebrew/opt/phoenix-osx/userjs/ui-fix/apple-maps/user.js
```

**Intel**:

```sh
/usr/local/opt/phoenix-osx/userjs/ui-fix/apple-maps/user.js
```

</details>

</details>

**<details><summary>Discord</summary>**

**<details><summary>GNU/Linux</summary>**

**Standard**:

```sh
/etc/firefox/phoenix/userjs/discord/user.js
```

**Flatpak**:

```sh
/var/lib/flatpak/app/org.mozilla.firefox/current/active/files/etc/firefox/phoenix/userjs/discord/user.js
```

</details>

**<details><summary>macOS</summary>**

**Apple Silicon**:

```sh
/opt/homebrew/opt/phoenix-osx/userjs/discord/user.js
```

**Intel**:

```sh
/usr/local/opt/phoenix-osx/userjs/discord/user.js
```

</details>

</details>

**<details><summary>Discord (Firefox-UI-Fix)</summary>**

**<details><summary>GNU/Linux</summary>**

**Standard**:

```sh
/etc/firefox/phoenix/userjs/ui-fix/discord/user.js
```

**Flatpak**:

```sh
/var/lib/flatpak/app/org.mozilla.firefox/current/active/files/etc/firefox/phoenix/userjs/ui-fix/discord/user.js
```

</details>

**<details><summary>macOS</summary>**

**Apple Silicon**:

```sh
/opt/homebrew/opt/phoenix-osx/userjs/ui-fix/discord/user.js
```

**Intel**:

```sh
/usr/local/opt/phoenix-osx/userjs/ui-fix/discord/user.js
```

</details>

</details>

**<details><summary>Element</summary>**

**<details><summary>GNU/Linux</summary>**

**Standard**:

```sh
/etc/firefox/phoenix/userjs/element/user.js
```

**Flatpak**:

```sh
/var/lib/flatpak/app/org.mozilla.firefox/current/active/files/etc/firefox/phoenix/userjs/element/user.js
```

</details>

**<details><summary>macOS</summary>**

**Apple Silicon**:

```sh
/opt/homebrew/opt/phoenix-osx/userjs/element/user.js
```

**Intel**:

```sh
/usr/local/opt/phoenix-osx/userjs/element/user.js
```

</details>

</details>

**<details><summary>Element (Firefox-UI-Fix)</summary>**

**<details><summary>GNU/Linux</summary>**

**Standard**:

```sh
/etc/firefox/phoenix/userjs/ui-fix/element/user.js
```

**Flatpak**:

```sh
/var/lib/flatpak/app/org.mozilla.firefox/current/active/files/etc/firefox/phoenix/userjs/ui-fix/element/user.js
```

</details>

**<details><summary>macOS</summary>**

**Apple Silicon**:

```sh
/opt/homebrew/opt/phoenix-osx/userjs/ui-fix/element/user.js
```

**Intel**:

```sh
/usr/local/opt/phoenix-osx/userjs/ui-fix/element/user.js
```

</details>

</details>

**<details><summary>Google Maps</summary>**

**<details><summary>GNU/Linux</summary>**

**Standard**:

```sh
/etc/firefox/phoenix/userjs/google-maps/user.js
```

**Flatpak**:

```sh
/var/lib/flatpak/app/org.mozilla.firefox/current/active/files/etc/firefox/phoenix/userjs/google-maps/user.js
```

</details>

**<details><summary>macOS</summary>**

**Apple Silicon**:

```sh
/opt/homebrew/opt/phoenix-osx/userjs/google-maps/user.js
```

**Intel**:

```sh
/usr/local/opt/phoenix-osx/userjs/google-maps/user.js
```

</details>

</details>

**<details><summary>Google Maps (Firefox-UI-Fix)</summary>**

**<details><summary>GNU/Linux</summary>**

**Standard**:

```sh
/etc/firefox/phoenix/userjs/ui-fix/google-maps/user.js
```

**Flatpak**:

```sh
/var/lib/flatpak/app/org.mozilla.firefox/current/active/files/etc/firefox/phoenix/userjs/ui-fix/google-maps/user.js
```

</details>

**<details><summary>macOS</summary>**

**Apple Silicon**:

```sh
/opt/homebrew/opt/phoenix-osx/userjs/ui-fix/google-maps/user.js
```

**Intel**:

```sh
/usr/local/opt/phoenix-osx/userjs/ui-fix/google-maps/user.js
```

</details>

</details>

**<details><summary>Twitter</summary>**

**<details><summary>GNU/Linux</summary>**

**Standard**:

```sh
/etc/firefox/phoenix/userjs/twitter/user.js
```

**Flatpak**:

```sh
/var/lib/flatpak/app/org.mozilla.firefox/current/active/files/etc/firefox/phoenix/userjs/twitter/user.js
```

</details>

**<details><summary>macOS</summary>**

**Apple Silicon**:

```sh
/opt/homebrew/opt/phoenix-osx/userjs/twitter/user.js
```

**Intel**:

```sh
/usr/local/opt/phoenix-osx/userjs/twitter/user.js
```

</details>

</details>

**<details><summary>Twitter (Firefox-UI-Fix)</summary>**

**<details><summary>GNU/Linux</summary>**

**Standard**:

```sh
/etc/firefox/phoenix/userjs/ui-fix/twitter/user.js
```

**Flatpak**:

```sh
/var/lib/flatpak/app/org.mozilla.firefox/current/active/files/etc/firefox/phoenix/userjs/ui-fix/twitter/user.js
```

</details>

**<details><summary>macOS</summary>**

**Apple Silicon**:

```sh
/opt/homebrew/opt/phoenix-osx/userjs/ui-fix/twitter/user.js
```

**Intel**:

```sh
/usr/local/opt/phoenix-osx/userjs/ui-fix/twitter/user.js
```

</details>

</details>

**<details><summary>YouTube</summary>**

**<details><summary>GNU/Linux</summary>**

**Standard**:

```sh
/etc/firefox/phoenix/userjs/youtube/user.js
```

**Flatpak**:

```sh
/var/lib/flatpak/app/org.mozilla.firefox/current/active/files/etc/firefox/phoenix/userjs/youtube/user.js
```

</details>

**<details><summary>macOS</summary>**

**Apple Silicon**:

```sh
/opt/homebrew/opt/phoenix-osx/userjs/youtube/user.js
```

**Intel**:

```sh
/usr/local/opt/phoenix-osx/userjs/youtube/user.js
```

</details>

</details>

**<details><summary>YouTube (Firefox-UI-Fix)</summary>**

**<details><summary>GNU/Linux</summary>**

**Standard**:

```sh
/etc/firefox/phoenix/userjs/ui-fix/youtube/user.js
```

**Flatpak**:

```sh
/var/lib/flatpak/app/org.mozilla.firefox/current/active/files/etc/firefox/phoenix/userjs/ui-fix/youtube/user.js
```

</details>

**<details><summary>macOS</summary>**

**Apple Silicon**:

```sh
/opt/homebrew/opt/phoenix-osx/userjs/ui-fix/youtube/user.js
```

**Intel**:

```sh
/usr/local/opt/phoenix-osx/userjs/ui-fix/youtube/user.js
```

</details>

</details>
