% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/borders.R
\name{vline_right}
\alias{vline_right}
\title{Set the right border of the table}
\usage{
vline_right(x, i = NULL, border = NULL, part = "all")
}
\arguments{
\item{x}{a 'flextable' object, see \link{flextable-package} to learn how to create
'flextable' object.}

\item{i}{row selector, see section \emph{Row selection with the \code{i} parameter}
in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.}

\item{border}{border properties defined by a call to
\code{\link[officer:fp_border]{officer::fp_border()}}}

\item{part}{part selector, see section \emph{Part selection with the \code{part}
parameter} in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.
Value 'all' can be used.}
}
\description{
\code{vline_right()} draws a vertical line along the \strong{right edge}
of the table by setting the right border of the last column.
It does not accept a column selector \code{j} because it always
targets the last column.

An optional row selector \code{i} lets you restrict the line to
specific rows.

Unlike \code{\link[=vline]{vline()}}, which adds inner lines to the right of
arbitrary columns, \code{vline_right()} is meant for the outer
right edge of the table.
}
\examples{
library(officer)
std_border <- fp_border(color = "orange")

ft <- flextable(head(iris))
ft <- border_remove(x = ft)

# add a border on the right edge of the table
ft <- vline_right(ft, border = std_border)
ft
}
\seealso{
Other borders management: 
\code{\link{border_inner}()},
\code{\link{border_inner_h}()},
\code{\link{border_inner_v}()},
\code{\link{border_outer}()},
\code{\link{border_remove}()},
\code{\link{hline}()},
\code{\link{hline_bottom}()},
\code{\link{hline_top}()},
\code{\link{surround}()},
\code{\link{vline}()},
\code{\link{vline_left}()}
}
\concept{borders management}
