% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_data.R
\name{new_data}
\alias{new_data}
\alias{data_grid}
\title{Create a data frame from all combinations of predictor values}
\usage{
new_data(model, terms, typical = "mean", condition = NULL, ...)

data_grid(model, terms, typical = "mean", condition = NULL, ...)
}
\arguments{
\item{model}{A fitted model object.}

\item{terms}{Character vector with the names of those terms from \code{model} for
which all combinations of values should be created. This argument works in
the same way as the \code{terms} argument in \code{predict_response()}. See also
\href{https://strengejacke.github.io/ggeffects/articles/introduction_effectsatvalues.html}{this vignette}.}

\item{typical}{Character vector, naming the function to be applied to the
covariates (non-focal terms) over which the effect is "averaged". The
default is \code{"mean"}. Can be \code{"mean"}, "\code{weighted.mean}", \code{"median"}, \code{"mode"}
or \code{"zero"}, which call the corresponding R functions (except \code{"mode"},
which calls an internal function to compute the most common value); \code{"zero"}
simply returns 0. By default, if the covariate is a factor, only \code{"mode"} is
applicable; for all other values (including the default, \code{"mean"}) the
reference level is returned. For character vectors, only the mode is returned.
You can use a named vector to apply different functions to integer, numeric and
categorical covariates, e.g. \code{typical = c(numeric = "median", factor = "mode")}.
If \code{typical} is \code{"weighted.mean"}, weights from the model are used. If no
weights are available, the function falls back to \code{"mean"}. \strong{Note} that this
argument is ignored for \code{predict_response()}, because the \code{margin} argument
takes care of this.}

\item{condition}{Named character vector, which indicates covariates that
should be held constant at specific values. Unlike \code{typical}, which
applies a function to the covariates to determine the value that is used
to hold these covariates constant, \code{condition} can be used to define
exact values, for instance \code{condition = c(covariate1 = 20, covariate2 = 5)}.
See 'Examples'.}

\item{...}{Currently not used.}
}
\value{
A data frame containing one row for each combination of values of the
supplied variables.
}
\description{
Create a data frame for the "newdata"-argument that contains
all combinations of values from the terms in questions. Similar to
\code{expand.grid()}. The \code{terms}-argument accepts all shortcuts
for representative values as in \code{predict_response()}.
}
\examples{
\dontshow{if (requireNamespace("datawizard", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(efc, package = "ggeffects")
fit <- lm(barthtot ~ c12hour + neg_c_7 + c161sex + c172code, data = efc)
new_data(fit, c("c12hour [meansd]", "c161sex"))

nd <- new_data(fit, c("c12hour [meansd]", "c161sex"))
pr <- predict(fit, type = "response", newdata = nd)
nd$predicted <- pr
nd

# compare to
predict_response(fit, c("c12hour [meansd]", "c161sex"))
\dontshow{\}) # examplesIf}
}
