% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label-date.R
\name{label_date}
\alias{label_date}
\alias{label_date_short}
\alias{label_time}
\alias{label_timespan}
\title{Label date/times}
\usage{
label_date(format = "\%Y-\%m-\%d", tz = "UTC", locale = NULL)

label_date_short(
  format = c("\%Y", "\%b", "\%d", "\%H:\%M"),
  sep = "\\n",
  leading = "0",
  tz = "UTC",
  locale = NULL
)

label_time(format = "\%H:\%M:\%S", tz = "UTC", locale = NULL)

label_timespan(
  unit = c("secs", "mins", "hours", "days", "weeks"),
  space = FALSE,
  ...
)
}
\arguments{
\item{format}{For \code{label_date()} and \code{label_time()} a date/time format
string using standard POSIX specification.  See \code{\link[=strptime]{strptime()}} for details.

For \code{label_date_short()} a character vector of length 4 giving the format
components to use for year, month, day, and hour respectively.}

\item{tz}{a time zone name, see \code{\link[=timezones]{timezones()}}. Defaults
to UTC}

\item{locale}{Locale to use when for day and month names. The default
uses the current locale. Setting this argument requires stringi, and you
can see a complete list of supported locales with
\code{\link[stringi:stri_locale_list]{stringi::stri_locale_list()}}.}

\item{sep}{Separator to use when combining date formats into a single string.}

\item{leading}{A string to replace leading zeroes with. Can be \code{""} to
disable leading characters or \code{"\\u2007"} for figure-spaces.}

\item{unit}{The unit used to interpret numeric input}

\item{space}{Add a space before the time unit?}

\item{...}{
  Arguments passed on to \code{\link[=number]{number}}
  \describe{
    \item{\code{accuracy}}{A number to round to. Use (e.g.) \code{0.01} to show 2 decimal
places of precision. If \code{NULL}, the default, uses a heuristic that should
ensure breaks have the minimum number of digits needed to show the
difference between adjacent values.

Applied to rescaled data.}
    \item{\code{scale}}{A scaling factor: \code{x} will be multiplied by \code{scale} before
formatting. This is useful if the underlying data is very small or very
large.}
    \item{\code{prefix}}{Additional text to display before the number. The suffix is
applied to absolute value before \code{style_positive} and \code{style_negative} are
processed so that \code{prefix = "$"} will yield (e.g.) \verb{-$1} and \verb{($1)}.}
    \item{\code{suffix}}{Additional text to display after the number.}
    \item{\code{big.mark}}{Character used between every 3 digits to separate thousands.
The default (\code{NULL}) retrieves the setting from the
\link[=number_options]{number options}.}
    \item{\code{decimal.mark}}{The character to be used to indicate the numeric
decimal point.  The default (\code{NULL}) retrieves the setting from the
\link[=number_options]{number options}.}
    \item{\code{style_positive}}{A string that determines the style of positive numbers:
\itemize{
\item \code{"none"} (the default): no change, e.g. \code{1}.
\item \code{"plus"}: preceded by \code{+}, e.g. \code{+1}.
\item \code{"space"}: preceded by a Unicode "figure space", i.e., a space equally
as wide as a number or \code{+}. Compared to \code{"none"}, adding a figure space
can ensure numbers remain properly aligned when they are left- or
right-justified.
}

The default (\code{NULL}) retrieves the setting from the
\link[=number_options]{number options}.}
    \item{\code{style_negative}}{A string that determines the style of negative numbers:
\itemize{
\item \code{"hyphen"} (the default): preceded by a standard hyphen \code{-}, e.g. \code{-1}.
\item \code{"minus"}, uses a proper Unicode minus symbol. This is a typographical
nicety that ensures \code{-} aligns with the horizontal bar of the
the horizontal bar of \code{+}.
\item \code{"parens"}, wrapped in parentheses, e.g. \code{(1)}.
}

The default (\code{NULL}) retrieves the setting from the
\link[=number_options]{number options}.}
    \item{\code{trim}}{Logical, if \code{FALSE}, values are right-justified to a common
width (see \code{\link[base:format]{base::format()}}).}
  }}
}
\value{
All \code{label_()} functions return a "labelling" function, i.e. a function that
takes a vector \code{x} and returns a character vector of \code{length(x)} giving a
label for each input value.

Labelling functions are designed to be used with the \code{labels} argument of
ggplot2 scales. The examples demonstrate their use with x scales, but
they work similarly for all scales, including those that generate legends
rather than axes.
}
\description{
\code{label_date()} and \code{label_time()} label date/times using date/time format
strings. \code{label_date_short()} automatically constructs a short format string
sufficient to uniquely identify labels. It's inspired by matplotlib's
\href{https://matplotlib.org/stable/api/dates_api.html#matplotlib.dates.ConciseDateFormatter}{\code{ConciseDateFormatter}},
but uses a slightly different approach: \code{ConciseDateFormatter} formats
"firsts" (e.g. first day of month, first day of day) specially;
\code{date_short()} formats changes (e.g. new month, new year) specially.
\code{label_timespan()} is intended to show time passed and adds common time units
suffix to the input (ns, us, ms, s, m, h, d, w).
}
\examples{
date_range <- function(start, days) {
  start <- as.POSIXct(start)
  c(start, start + days * 24 * 60 * 60)
}

two_months <- date_range("2020-05-01", 60)
demo_datetime(two_months)
demo_datetime(two_months, labels = label_date("\%m/\%d"))
demo_datetime(two_months, labels = label_date("\%e \%b", locale = "fr"))
demo_datetime(two_months, labels = label_date("\%e \%B", locale = "es"))
# ggplot2 provides a short-hand:
demo_datetime(two_months, date_labels = "\%m/\%d")

# An alternative labelling system is label_date_short()
demo_datetime(two_months, date_breaks = "7 days", labels = label_date_short())
# This is particularly effective for dense labels
one_year <- date_range("2020-05-01", 365)
demo_datetime(one_year, date_breaks = "month")
demo_datetime(one_year, date_breaks = "month", labels = label_date_short())
}
