<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Symfony\Component\JsonStreamer\ValueTransformer;

use Symfony\Component\TypeInfo\Type;

/**
 * Transforms a native value before stream writing and after stream reading.
 *
 * @author Mathias Arlaud <mathias.arlaud@gmail.com>
 */
interface ValueTransformerInterface
{
    /**
     * @param array{
     *     _current_object?: object, // When writing stream: the object holding the current property
     *     ...<string, mixed>,
     * } $options
     */
    public function transform(mixed $value, array $options = []): mixed;

    public static function getStreamValueType(): Type;
}
