---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, symboles, polices, taille des caractères, 
              agrandir la police, réduire la police
---

# Comment changer la taille d'une police ?

Vous pouvez utiliser des commandes de changement de taille, 
dont le rôle est de modifier la taille du texte *à partir de leur exécution* :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Voici un texte d'\Large exemple. \tiny Et une suite.
\end{document}
```

En général, on souhaite appliquer ce changement à une petite portion du document. 
On applique donc ces commande à l'intérieur d'un bloc délimité par des accolades :

```{noedit}
Voici un texte d'{\Large exemple}. Et une suite.
```

Les différentes commandes de taille sont listées dans l'exemple suivant,
 de la plus petite à la plus grande :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\begin{tabular}{lc}
\verb+\tiny+         & \tiny Lorem ipsum           \\
\verb+\scriptsize+   & \scriptsize Lorem ipsum     \\
\verb+\footnotesize+ & \footnotesize Lorem ipsum   \\
\verb+\small+        & \small Lorem ipsum          \\
\verb+\normalsize+   & \normalsize Lorem ipsum     \\
\verb+\large+        & \large Lorem ipsum          \\
\verb+\Large+        & \Large Lorem ipsum          \\
\verb+\LARGE+        & \LARGE Lorem ipsum          \\
\verb+\huge+         & \huge Lorem ipsum           \\
\verb+\Huge+         & \Huge Lorem ipsum           \\
\end{tabular}
\end{document}
```

Le nom de `\footnotesize` vient du fait que cette taille sert pour les notes de bas de page.
De même, `\normalsize` correspond à la taille par défaut du texte.

Ces commandes sont prédéfinies en fonction de la classe de votre document.

Il faut noter que ces commandes s'occupent automatiquement d'adapter la hauteur de l'interligne.
Mais c'est la taille courante **à la fin du paragraphe** qui détermine l'interligne du paragraphe. 
Il est donc important que la fin de paragraphe (ligne vide ou commande `\par`) 
soit **dans** le bloc dont la taille de texte est changée. 
Cet effet est parfois utilisé dans une méthode présentée à la question 
"[](/3_composition/texte/paragraphes/interlignage/modifier_l_interligne)".


## D'autres possibilités

Pour disposer de quelques tailles en plus, utilisez l'extension <ctanpkg:moresize>. 
Elle vous fournira les commandes :

- `\HUGE`, encore plus grand que `\Huge`,
- `\ssmall`, intermédiaire entre `\tiny` et `\scriptsize`.

Si vous voulez contrôler précisément les tailles (en points) de vos caractères, 
vous pouvez utiliser la commande `\fontsize` détaillée à la question 
"[](/3_composition/texte/paragraphes/interlignage/pourquoi_linespread_ne_fonctionne_pas)".

Enfin, l'extension <ctanpkg:fontsize> vous ouvre la possibilité de définir très précisément
la taille de base de votre document, puis vous fournit 4 fois plus de commandes que LaTeX 
pour changer la taille de caractère en cours de document. 
[Sa documentation](texdoc:fontsize) est très complète, avec des exemples.


## Cas de l'utilisation de `\scalebox` ou `\resizebox`

Si vous souhaitez obtenir un texte de hauteur parfaitement déterminée, 
vous pouvez imaginer utiliser les commandes `\scalebox` ou `\resizebox`, 
fournies par l'extension <ctanpkg:graphicx>, qui modifient la taille de leur contenu.

Techniquement, ça fonctionne :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{graphicx}

\begin{document}
\resizebox{!}{4ex}{Grand texte !}
\end{document}
```

Mais si vous mélangez différentes tailles de texte obtenues de cette façon, 
vous vous apercevrez que le rendu est étrange. Ici, le texte semble être en gras :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{graphicx}

  \newlength{\hauteur}
  \settoheight{\hauteur}{\Huge Grand texte.}

\begin{document}
Ceci est du texte de taille normale.

\resizebox{!}{\hauteur}{Grand texte.}

À nouveau de taille normale.
\bigskip

Ceci est du texte de taille normale.

{\Huge Grand texte.}

À nouveau de taille normale.
\end{document}
```

En fait, les commandes de changement de taille ne modifient pas la taille 
de façon strictement géométrique. L'épaisseur des traits est également modifiée 
pour que les petites tailles de texte ne semblent pas dessinées avec un trait trop fin 
(et inversement, que les grandes tailles de texte ne semblent pas être en gras, comme ici).

Si on remet toutes les tailles de texte à la même hauteur (ici `4mm`), 
on peut oberver que le dessin des lettres est légèrement différent d'une taille à l'autre :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{graphicx}

\begin{document}
\begin{tabular}{ll}
\verb+tiny+        & \resizebox{!}{4mm}{\tiny Peux-tu m'envoyer du whisky ?}        \\
\verb+scriptsize+  & \resizebox{!}{4mm}{\scriptsize Peux-tu m'envoyer du whisky ?}  \\
\verb+footnotesize+& \resizebox{!}{4mm}{\footnotesize Peux-tu m'envoyer du whisky ?}\\
\verb+small+       & \resizebox{!}{4mm}{\small Peux-tu m'envoyer du whisky ?}       \\
\verb+normalsize+  & \resizebox{!}{4mm}{\normalsize Peux-tu m'envoyer du whisky ?}  \\
\verb+large+       & \resizebox{!}{4mm}{\large Peux-tu m'envoyer du whisky ?}       \\
\verb+Large+       & \resizebox{!}{4mm}{\Large Peux-tu m'envoyer du whisky ?}       \\
\verb+LARGE+       & \resizebox{!}{4mm}{\LARGE Peux-tu m'envoyer du whisky ?}       \\
\verb+huge+        & \resizebox{!}{4mm}{\huge Peux-tu m'envoyer du whisky ?}        \\
\verb+Huge+        & \resizebox{!}{4mm}{\Huge Peux-tu m'envoyer du whisky ?}        \\
\end{tabular}
\end{document}
```

Ceci contribue à la qualité esthétique du document final : 
si dans la page, vous avez un paragraphe composé en caractères plus petits (par exemple une citation),
ce paragraphe ne paraîtra pas plus clair ou plus foncé que le reste de la page 
(ces considérations rejoignent la notion de [gris typographique](wpfr:Gris_typographique)).