---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, symboles,
              ce qu'il fallait démontrer, quod erta demonstrandum, 
              ὅπερ ἔδει δεῖξαι, carré blanc, carré noir, 
              signe de fin de démonstration
---

# Comment ajouter un carré en fin de démonstration ?

Ce symbole est utilisé pour remplacer l'expression latine 
*quod erat demonstrandum* (QED), autrement dit notre 
[CQFD](wpfr:CQFD_(mathématiques)). Il est parfois appelé "halmos", du nom 
du mathématicien [Paul Halmos](wpfr:Paul_Halmos).

L'obtention de ce symbole n'est pas compliquée, il s'agit du symbole LaTeX
mathématique `\square`. La problématique tient plus à son positionnement 
sur la ligne du document où elle vient conclure la démonstration.


## Avec l'extension <ctanpkg:amsthm>

L'extension <ctanpkg:amsthm> fournit un environnement `proof` qui ajoute
automatiquement ce symbole en fin de démonstration :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{amsthm}

\begin{document}
\begin{proof}
  (...) Et, par récurrence :
  \[  (X+Y)^{n} = \sum_{{k=0}}^{n} {n \choose k} X^{{n-k}} Y^{k}  \]
  Ce qui généralise l'\emph{identité polynomiale}.
\end{proof}
\end{document}
```

Notez bien que <ctanpkg:amsthm> propose par des défauts 
des dénominations anglaises (comme *Proof*). Vous devez donc 
charger <ctanpkg:babel> et passer l'option `french` pour retrouver 
une terminologie francisée.

Cependant, si la démonstration se termine par une formule en exergue, 
le symbole CQFD risque d'apparaître trop bas. Son placement pourra être corrigé
en utilisant la commande `\qedhere` comme étiquette de formule, 
avec la commande `\tag`. En voici un exemple :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{amsthm,mathtools}

\begin{document}
Sans correction :
\begin{proof}
  Texte...
  \begin{equation*}
    maths...
  \end{equation*}
\end{proof}

Avec correction :
\begin{proof}
  Texte...
  \begin{equation*}
    maths... \tag*{\qedhere}
  \end{equation*}
\end{proof}
\end{document}
```


### Changer le symbole de fin de démonstration

Il est très simple de changer le symbole de fin de démonstration, 
en redéfinissant la commande `\qedsymbol` :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{amsthm,amssymb}

  \renewcommand{\qedsymbol}{$\blacksquare$}

\begin{document}
\begin{proof}
  Et nous y voilà.
\end{proof}
\end{document}
```

De la même façon, il est très simple de faire disparaître le carré, en
redéfinissant `\qedsymbol` pour qu'elle ne fasse rien :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)  
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{amsthm}

  \renewcommand{\qedsymbol}{}

\begin{document}
\begin{proof}
  Et nous y voilà.
\end{proof}
\end{document}
```


## Avec l'extension <ctanpkg:ntheorem>

L'extension <ctanpkg:ntheorem> vous permet de définir de nouveaux styles 
de théorèmes, de lemme, de démonstration, etc.

Avec l'option `standard`, elle vous fournit un ensemble d'environnements
prédéfinis, dont `Proof` pour les démonstrations. En ajoutant l'option
`thmmarks`, vous ferez apparaître des marques de fin de démonstration :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage[standard,thmmarks]{ntheorem}

\begin{document}
\begin{Proof}
  (...) Et, par récurrence :
  \[  (X+Y)^{n} = \sum_{{k=0}}^{n} {n \choose k} X^{{n-k}} Y^{k}  \]
  Ce qui généralise l'\emph{identité polynomiale}.
\end{Proof}
\end{document}
```

Malgré l'usage de l'extension <ctanpkg:babel> et de l'option `french`, 
le terme anglais *Proof* reste utilisé. L'extension ne propose en effet 
pas d'options de localisation en français et <ctanpkg:babel> ne permet pas
non plus de résoudre ce point. Cependant, l'extension dispose de commandes
pour créer (`\newtheorem`) et paramétrer 
de nouveaux environnements mathématiques. Dès lors, il est possible 
de dupliquer les environnements comme `Proof` et de les franciser, 
comme dans l'exemple suivant. 

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage[standard,thmmarks]{ntheorem}

  \theoremheaderfont{\scshape}    % Police du titre du "théorème"
  \theorembodyfont{\normalfont}   % Police du texte du "théorème"
  \theoremstyle{nonumberplain}    % Style du "théorème" (ici, sans numéro)
  \theoremseparator{}             % Séparateur en cas numérotation
  \theoremsymbol{%                % Symbole de fin de "théorème" 
    \ensuremath{_\blacksquare}}  
  \newtheorem{dem}{Démonstration} % Définition de notre nouvel environnement
                                  % avec les paramètres qui précèdent

\begin{document}
\begin{dem}
  (...) Et, par récurrence :
  \[  (X+Y)^{n} = \sum_{{k=0}}^{n} {n \choose k} X^{{n-k}} Y^{k}  \]
  Ce qui généralise l'\emph{identité polynomiale}.
\end{dem}
\end{document}
```

Les définitions par défaut des environnements de l'extension <ctanpkg:ntheorem>
sont données dans sa [documentation](texdoc:ntheorem) à la section 4 *Examples*
(dans notre exemple, nous avons également modifié le symbole de fin).

Par ailleurs, si la [documentation](texdoc:ntheorem) de cette extension 
reste un peu théorique, vous trouverez sur le 
[site du Zeste de Savoir](https://zestedesavoir.com/tutoriels/1126/des-theoremes-personnalises-en-latex/) 
des exemples bien plus pédagogiques en français.


## Avec l'extension <ctanpkg:QED>

L'extension <ctanpkg:QED>, de Paul Taylor, définit un environnement de preuve,
`Proof`, et une commande `\qed`. Vous devrez charger manuellement l'extension
<ctanpkg:amssymb> pour disposer du symbole carré.

Vous aurez également à disposition ces variantes :

| Commande | Rendu     | Signification                                          |
|----------|-----------|--------------------------------------------------------|
| `\qed`   | $\square$ | *Quod erat demonstrandum* / Ce qu'il fallait démontrer |
| `\QED`   | Q.E.D.    | *Quod erat demonstrandum* / Ce qu'il fallait démontrer |
| `\QEI`   | Q.E.I.    | *Quod erat inveniendum* / Ce qu'il fallait trouver     |
| `\QEF`   | Q.E.F.    | *Quod erat faciendum* / Ce qu'il fallait faire         |

Notez que ces commandes (`\qed`, `\QED`, etc) n'ont pas d'effet 
si elles ne suivent pas une commande qui démarre une preuve (`\begin{Proof}` 
ou `\Proof`).

:::{warning} 
L'extension <ctanpkg:QED> a été développée en 1993-1995. Avec elle, Paul Taylor
a apporté une solution automatique à un problème délicat : en effet, 
certaines preuves se terminent par une équation en exergue, d'autres non. 
Si le fichier d'entrée contient `...\] \end{proof}`, LaTeX achève la composition
des mathématiques, puis se prépare immédiatement pour une nouvelle ligne, 
avant même de lire le code de la fin de démonstration.

Cette extention a donc un intérêt historique et son code reste
intéressant. Mais les autres solutions proposées sont préférables si vous
travaillez sur un document récent.
:::


## Avec des modifications manuelles

Si vos besoins sont simples, une commande `\qed` peut être définie
manuellement (pour du texte) :

```{noedit}
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools, amssymb}

  % Définition d'un symbole \qed
  \newcommand{\monhfill}{
    \parfillskip=0pt
    \widowpenalty=10000
    \displaywidowpenalty=10000
    \finalhyphendemerits=0
    \unskip\nobreak\null\hfil\penalty50
    \hskip2em\null\hfill
  }
  \newcommand{\symboleqed}{\ensuremath{\square}}
  \newcommand{\qed}{\monhfill\symboleqed\par}

\begin{document}
(...) Et, par récurrence :
\[  (X+Y)^{n} = \sum_{{k=0}}^{n} {n \choose k} X^{{n-k}} Y^{k} \]
Ce qui généralise l'\emph{identité polynomiale}.\qed
\end{document}
```

Le symbole de fin de démonstration sera placé à droite, sur la ligne s'il reste
de la place, sur la ligne d'en-dessous dans le cas contraire.


:::{sources}
- [Signe de fin d'article](wpfr:Signe_de_fin_d'article)
- [QED symbol in latex](https://stackoverflow.com/q/1910493), 
  sur [Stack Overflow](https://tex.stackexchange.com/)
- [Solid black box in the proof environment](https://tex.stackexchange.com/q/98382),
  sur [Tex Stack Exchange](https://tex.stackexchange.com/)
- [Proof environment](faquk:FAQ-proof)
:::