% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/se.R
\name{se0}
\alias{se0}
\title{MDYPL state evolution functions with no intercept}
\usage{
se0(mu, b, sigma, kappa, gamma, alpha, gh = NULL, prox_tol = 1e-10)
}
\arguments{
\item{mu}{aggregate bias parameter.}

\item{b}{parameter \code{b} in the state evolution functions.}

\item{sigma}{square root of the aggregate variance of the MDYPL
estimator.}

\item{kappa}{asymptotic ratio of columns/rows of the design
matrix. \code{kappa} should be in \verb{(0, 1)}.}

\item{gamma}{the square root of the limit of the variance of the
linear predictor.}

\item{alpha}{the shrinkage parameter of the MDYPL
estimator. \code{alpha} should be in \verb{(0, 1)}.}

\item{gh}{A list with the Gauss-Hermite quadrature nodes and
weights, as returned from \code{statmod::gauss.quad()} with \code{kind = "hermite"}. Default is \code{NULL}, in which case \code{gh} is set to
\code{statmod::gauss.quad(200, kind = "hermite")} is used.}

\item{prox_tol}{tolerance for the computation of the proximal
operator; default is \code{1e-10}.}
}
\description{
MDYPL state evolution functions with no intercept
}
