% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step-subset-separate.R
\name{separate.dtplyr_step}
\alias{separate.dtplyr_step}
\title{Separate a character column into multiple columns with a regular
expression or numeric locations}
\usage{
\method{separate}{dtplyr_step}(
  data,
  col,
  into,
  sep = "[^[:alnum:]]+",
  remove = TRUE,
  convert = FALSE,
  ...
)
}
\arguments{
\item{data}{A \code{\link[=lazy_dt]{lazy_dt()}}.}

\item{col}{Column name or position.

This argument is passed by expression and supports quasiquotation
(you can unquote column names or column positions).}

\item{into}{Names of new variables to create as character vector.
Use \code{NA} to omit the variable in the output.}

\item{sep}{Separator between columns.
The default value is a regular expression that matches any sequence of non-alphanumeric values.}

\item{remove}{If TRUE, remove the input column from the output data frame.}

\item{convert}{If TRUE, will run type.convert() with as.is = TRUE on new columns.
This is useful if the component columns are integer, numeric or logical.

NB: this will cause string "NA"s to be converted to NAs.}

\item{...}{Arguments passed on to methods}
}
\description{
This is a method for the \code{\link[tidyr:separate]{tidyr::separate()}} generic. It is translated to
\code{\link[data.table:tstrsplit]{data.table::tstrsplit()}} in the \code{j} argument of \verb{[.data.table}.
}
\examples{
library(tidyr)
# If you want to split by any non-alphanumeric value (the default):
df <- lazy_dt(data.frame(x = c(NA, "x.y", "x.z", "y.z")), "DT")
df \%>\% separate(x, c("A", "B"))

# If you just want the second variable:
df \%>\% separate(x, c(NA, "B"))

# Use regular expressions to separate on multiple characters:
df <- lazy_dt(data.frame(x = c(NA, "x?y", "x.z", "y:z")), "DT")
df \%>\% separate(x, c("A","B"), sep = "([.?:])")

# convert = TRUE detects column classes:
df <- lazy_dt(data.frame(x = c("x:1", "x:2", "y:4", "z", NA)), "DT")
df \%>\% separate(x, c("key","value"), ":") \%>\% str
df \%>\% separate(x, c("key","value"), ":", convert = TRUE) \%>\% str
}
