// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from CardReader.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.smartcard {
  public class CardReader_1_0_3 : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("smartcard.CardReader:1.0.3", null);

    public CardReader_1_0_3(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public CardReader_1_0_3(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new CardReader_1_0_3 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new CardReader_1_0_3(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int NO_ERROR = 0;

    public const int ERR_SLOT_EMPTY = 1;

    public class MetaData : ICloneable {
      public object Clone() {
        MetaData copy = new MetaData();
        copy.id = this.id;
        copy.manufacturer = this.manufacturer;
        copy.product = this.product;
        copy.serialNumber = this.serialNumber;
        copy.channel = this.channel;
        copy.position = this.position;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["id"] = this.id;
        json["manufacturer"] = this.manufacturer;
        json["product"] = this.product;
        json["serialNumber"] = this.serialNumber;
        json["channel"] = this.channel;
        json["position"] = this.position;
        return json;
      }

      public static MetaData Decode(LightJson.JsonObject json, Agent agent) {
        MetaData inst = new MetaData();
        inst.id = (string)json["id"];
        inst.manufacturer = (string)json["manufacturer"];
        inst.product = (string)json["product"];
        inst.serialNumber = (string)json["serialNumber"];
        inst.channel = (int)json["channel"];
        inst.position = (string)json["position"];
        return inst;
      }

      public string id = "";
      public string manufacturer = "";
      public string product = "";
      public string serialNumber = "";
      public int channel = 0;
      public string position = "";
    }

    public class CardInformation : ICloneable {
      public object Clone() {
        CardInformation copy = new CardInformation();
        copy.type = this.type;
        copy.uid = this.uid;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["type"] = this.type;
        json["uid"] = this.uid;
        return json;
      }

      public static CardInformation Decode(LightJson.JsonObject json, Agent agent) {
        CardInformation inst = new CardInformation();
        inst.type = (string)json["type"];
        inst.uid = (string)json["uid"];
        return inst;
      }

      public string type = "";
      public string uid = "";
    }

    public class CardEvent : Com.Raritan.Idl.idl.Event {
      static public readonly new TypeInfo typeInfo = new TypeInfo("smartcard.CardReader_1_0_3.CardEvent:1.0.0", Com.Raritan.Idl.idl.Event.typeInfo);

      public Com.Raritan.Idl.smartcard.CardReader_1_0_3.CardInformation cardInfo = new Com.Raritan.Idl.smartcard.CardReader_1_0_3.CardInformation();
    }

    public class CardInsertedEvent : Com.Raritan.Idl.smartcard.CardReader_1_0_3.CardEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("smartcard.CardReader_1_0_3.CardInsertedEvent:1.0.0", Com.Raritan.Idl.smartcard.CardReader_1_0_3.CardEvent.typeInfo);

    }

    public class CardRemovedEvent : Com.Raritan.Idl.smartcard.CardReader_1_0_3.CardEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("smartcard.CardReader_1_0_3.CardRemovedEvent:1.0.0", Com.Raritan.Idl.smartcard.CardReader_1_0_3.CardEvent.typeInfo);

    }

    public class GetMetaDataResult {
      public Com.Raritan.Idl.smartcard.CardReader_1_0_3.MetaData _ret_;
    }

    public GetMetaDataResult getMetaData() {
      JsonObject _parameters = null;
      var _result = RpcCall("getMetaData", _parameters);
      var _ret = new GetMetaDataResult();
      _ret._ret_ = Com.Raritan.Idl.smartcard.CardReader_1_0_3.MetaData.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getMetaData(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getMetaData", _parameters,
        _result => {
          try {
            var _ret = new GetMetaDataResult();
            _ret._ret_ = Com.Raritan.Idl.smartcard.CardReader_1_0_3.MetaData.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetCardInformationResult {
      public int _ret_;
      public Com.Raritan.Idl.smartcard.CardReader_1_0_3.CardInformation cardInfo;
    }

    public GetCardInformationResult getCardInformation() {
      JsonObject _parameters = null;
      var _result = RpcCall("getCardInformation", _parameters);
      var _ret = new GetCardInformationResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.cardInfo = Com.Raritan.Idl.smartcard.CardReader_1_0_3.CardInformation.Decode(_result["cardInfo"], agent);
      return _ret;
    }

    public AsyncRequest getCardInformation(AsyncRpcResponse<GetCardInformationResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getCardInformation(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getCardInformation(AsyncRpcResponse<GetCardInformationResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getCardInformation", _parameters,
        _result => {
          try {
            var _ret = new GetCardInformationResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.cardInfo = Com.Raritan.Idl.smartcard.CardReader_1_0_3.CardInformation.Decode(_result["cardInfo"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
